unit BrushU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    StylesGroup: TRadioGroup;
    procedure StylesGroupClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.StylesGroupClick(Sender: TObject);
begin
  Refresh;
end;

procedure TMainForm.FormPaint(Sender: TObject);
begin
  Canvas.Brush.Color := clBlue;
  case StylesGroup.ItemIndex of
    0 : begin
        Canvas.Brush.Style := bsSolid;
        Canvas.Ellipse(150, 50, 400, 300);
      end;
    1 : begin
        Canvas.Brush.Style := bsDiagCross;
        Canvas.Ellipse(150, 50, 400, 300);
      end;
    2 : begin
        Canvas.Brush.Bitmap := TBitmap.Create;
        Canvas.Brush.Bitmap.LoadFromFile('bkgnd.bmp');
        Canvas.Ellipse(150, 50, 400, 300);
        Canvas.Brush.Bitmap.Free;
      end;
    3 : begin
        Canvas.Brush.Style := bsSolid;
        Canvas.Ellipse(150, 50, 400, 300);
        Canvas.Brush.Style := bsClear;
        Canvas.Ellipse(250, 100, 450, 300);
      end;
  end;
end;

end.
