unit DbgTestU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    WatchBtn: TButton;
    InspectBtn: TButton;
    CrashBtn: TButton;
    BadCrashBtn: TButton;
    Memo1: TMemo;
    procedure WatchBtnClick(Sender: TObject);
    procedure InspectBtnClick(Sender: TObject);
    procedure CrashBtnClick(Sender: TObject);
    procedure BadCrashBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure BeepFunction;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  LockForm: Boolean;

implementation

{$R *.DFM}

procedure TMainForm.WatchBtnClick(Sender: TObject);
var
  S : string;
  X, Y : Integer;
begin
  OutputDebugString('Wykonano WatchBtnClick');

  { dodaj zmienne S, X, Y do listy wyrae testowych }
  { i obserwuj zmian ich wartoci w trakcie pracy krokowej }

  X := Width;
  S := IntToStr(X);
  Y := Height;
  X := X * Y;
  S := IntToStr(X);
  X := X div Y;

  {USTAW PUNKT PRZERWANIA W PONISZEJ LINII}
  S := 'X = ' + IntToStr(X);
  OutputDebugString(PChar(S));


  { Ponisze wywoanie powoduje emisj sygnau dwikowego }
  { Moesz ograniczy si do wykonania funkcji (F8), moesz }
  { te wej do jej wntrza (F7). }


  BeepFunction;

  { Kliknij w przycisk Run, by przywrci normaln prac programu }
  Width := X;
  Height := Y;
end;

procedure TMainForm.InspectBtnClick(Sender: TObject);
var
  List : TStringList;
begin
  OutputDebugString('Wykonano InspectBtnClick');
  List := TStringList.Create;
  List.Add('To jest test');
  List.Add('Josh, Jenna, James');

  {USTAW PUNKT PRZERWANIA W PONISZEJ LINII}
  List.Add('Marshall, Mallory, Mason');

  {Kliknij identyfikator "List" w powyszej linii}
  {i wybierz "Inspect" z jego menu kontekstowego }
  {lub nacinij Alt-F5 - wywietlone zostanie okno}
  {inspektora ledzenia                           }

  List.Free;
  { Kliknij w przycisk Run, by przywrci normaln prac programu }
end;

procedure TMainForm.CrashBtnClick(Sender: TObject);
var
  List : TStringList;
begin
  OutputDebugString('Wykonano CrashBtnClick');

  {Wykonanie drugiej z poniszych linii spowoduje}
  {zaamanie si programu z powodu prby adresowania pamici}
  {za pomoc pustego wskanika. Zaamanie wystpi zawsze, }
  {poniewa wskanik jawnie jest inicjowany pust wartoci}

  List := nil;
  List.Add('test');
end;

procedure TMainForm.BadCrashBtnClick(Sender: TObject);
var
  List : TStringList;
begin
  OutputDebugString('Wykonano BadCrashBtnClick');

  {Wykonanie poniszej linii moe, cho nie musi, spowodowa}
  {zaamanie si programu z powodu prby adresowania pamici}
  {za pomoc wskanika o przypadkowej zawartoci}


  List.Add('test');
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  OutputDebugString('Utworzono plik dziennika');
  OutputDebugString('Obsuono zdarzenie OnCreate.');
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  OutputDebugString('Obsuono zdarzenie OnDestroy');
end;

procedure TMainForm.BeepFunction;
begin
  OutputDebugString('Wykonano BeepFunction');
  MessageBeep(0);
end;

end.
