

unit SPMain;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ToolWin;
type
  TMainForm = class(TForm)
  StatusBar: TStatusBar;
  ToolBar1: TToolBar;
  ToolButton1: TToolButton;
  ToolButton2: TToolButton;
  Memo: TMemo;
  MainMenu: TMainMenu;
  FileMenu: TMenuItem;
  FileNew: TMenuItem;
  FileOpen: TMenuItem;
  FileSave: TMenuItem;
  FileSaveAs: TMenuItem;
  N1: TMenuItem;
  FilePrint: TMenuItem;
  FilePrintSetup: TMenuItem;
  N2: TMenuItem;
  FileExit: TMenuItem;
  Edit1: TMenuItem;
  EditReplace: TMenuItem;
  EditFind: TMenuItem;
  N4: TMenuItem;
  EditPaste: TMenuItem;
  EditCopy: TMenuItem;
  EditCut: TMenuItem;
  N5: TMenuItem;
  EditUndo: TMenuItem;
  Help1: TMenuItem;
  HelpAbout: TMenuItem;
  HelpContents: TMenuItem;
  EditSelectAll: TMenuItem;
  N3: TMenuItem;
  EditWordWrap: TMenuItem;
  OpenDialog: TOpenDialog;
  SaveDialog: TSaveDialog;
  MemoPopup: TPopupMenu;
  PopupCut: TMenuItem;
  PopupCopy: TMenuItem;
  PopupPaste: TMenuItem;
  procedure FileExitClick(Sender: TObject);
  procedure EditCutClick(Sender: TObject);
  procedure EditCopyClick(Sender: TObject);
  procedure EditPasteClick(Sender: TObject);
  procedure FileNewClick(Sender: TObject);
  procedure FileSaveClick(Sender: TObject);
  procedure FileOpenClick(Sender: TObject);
  procedure FileSaveAsClick(Sender: TObject);
  procedure EditUndoClick(Sender: TObject);
  procedure EditSelectAllClick(Sender: TObject);
  procedure EditWordWrapClick(Sender: TObject);
  procedure HelpAboutClick(Sender: TObject);
  
private
{ Deklaracje prywatne }
public
{ Deklaracje publiczne }
end;

var
  MainForm: TMainForm;

implementation
uses 
  SPAbout;
{$R *.DFM}
procedure TMainForm.FileExitClick(Sender: TObject);
begin
{ Zamknij formularz. }
  Close;
end;

procedure TMainForm.EditCutClick(Sender: TObject);
begin
  { Wywoaj TMemo.CutToClipboard. }
  Memo.CutToClipboard;
end;

procedure TMainForm.EditCopyClick(Sender: TObject);
begin
  { Wywoaj TMemo.CopyToClipboard. }
  Memo.CopyToClipboard;
end;

procedure TMainForm.EditPasteClick(Sender: TObject);
begin
  { Wywoaj TMemo.PasteFromClipboard. }
  Memo.PasteFromClipboard;
end;

procedure TMainForm.FileNewClick(Sender: TObject);
var
  Res : Integer;
begin
  { Otwrz plik. Najpierw sprawd czy }
  { aktualny plik wymaga zapisania    }
  if Memo.Modified then 
  begin
    { Wywietl okno informacyjne (message box). }
    Res := Application.MessageBox(
             'Plik zosta zmieniony. Czy zapisa zmiany?',
             'Notatnik', MB_YESNOCANCEL);
  { Jeeli kliknito Yes (Tak), zapisz aktualny plik. }
    if Res = IDYES 
    then
      FileSaveClick(Sender);

  { Jeli kliknito No (Nie) nie rb nic. }
    if Res = IDCANCEL 
    then
      Exit;
  end;

  { Jeli w memo znajduj si jakie wiersze tekstu, skasuj je.}
  if Memo.Lines.Count > 0 
  then
    Memo.Clear;
  
  { Ustaw waciwo FileName komponentu Save Dialog jako }
  { cig pusty. Pozwoli to zorientowa si, e plik nie    }
  { zosta jeszcze zapisany. }
  SaveDialog.FileName := '';
end;

procedure TMainForm.FileOpenClick(Sender: TObject);
var
  Res : Integer;
begin
  { Otwrz plik. Najpierw sprawd czy }
  { aktualny plik wymaga zapisania. Ta sama zasada co w przypadku    
    FileNewClick. } 
  if Memo.Modified then 
  begin
    Res := Application.MessageBox(
             'Plik zosta zmieniony. Czy zapisa zmiany?',
             'Notatnik', MB_YESNOCANCEL);

    if Res = IDYES 
    then
      FileSaveClick(Sender);
    if Res = IDCANCEL 
    then
      Exit;
  end;
  { Wywoaj dialog File Open. Jeli wcinito OK         }
  { otwrz plik uywajc metody LoadFromFile. Najpierw   }
  { wyczy waciwo FileName. }
  OpenDialog.FileName := '';
  if OpenDialog.Execute then 
  begin
    if Memo.Lines.Count > 0 
    then
      Memo.Clear;
    Memo.Lines.LoadFromFile(OpenDialog.FileName);
    SaveDialog.FileName := OpenDialog.FileName;
  end;
end;

procedure TMainForm.FileSaveClick(Sender: TObject);
begin
  { Jeli nazwa pliku zostaa ju podana, nie ma potrzeby   }
  { wywoywania dialogu File Save. Wystarczy zapisa        }
  { plik uywajc SaveToFile. }
  if SaveDialog.FileName <> '' then 
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);
    { Poniewa wanie zapisalimy plik, ustaw Modified na False. }
    Memo.Modified := False;
    { Jeli nie jest znana nazwa pliku, wykonaj SaveAs. }
  end 
  else 
    FileSaveAsClick(Sender);
end;

procedure TMainForm.FileSaveAsClick(Sender: TObject);
begin
  { Aby zapisa plik, wywietl dialog File Save. }
  { Poniewa wanie zapisalimy plik, ustaw  Modified na False. }
  SaveDialog.Title := 'Zapisz jako';
  if SaveDialog.Execute then 
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);
    Memo.Modified := False;
  end;
end;

procedure TMainForm.EditUndoClick(Sender: TObject);
begin
  { Poniewa komponent TMemo nie posiada metody Undo, musimy wysa }
  { komunikat Windows WM_UNDO do komponentu memo.     }
  SendMessage(Memo.Handle, WM_UNDO, 0, 0);
end;

procedure TMainForm.EditSelectAllClick(Sender: TObject);
begin
  { Wywoaj TMemo.SelectAll. }
  Memo.SelectAll;
end;

procedure TMainForm.EditWordWrapClick(Sender: TObject);
begin
  { Przecz na przeciwn warto komponentu TMemo.WordWrap. Ustaw waciwo    
    Checked }
  { elementu menu na tak sam warto jak WordWrap. }
  Memo.WordWrap := not Memo.WordWrap;
  EditWordWrap.Checked := Memo.WordWrap;
  { Jeli WordWrap (zawijanie wierszy) jest wczone potrzebujemy }
  { tylko pionowego paska przewijania. Jeli wyczone,           }
  { potrzebujemy obu paskw.                                      }
  if Memo.WordWrap 
  then
    Memo.ScrollBars := ssVertical
  else
    Memo.ScrollBars := ssBoth;
end;

procedure TMainForm.HelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.


