unit AirplanU;

interface

uses
  SysUtils;

const
  { typy samolotw }
  Airliner     = 0;
  Commuter     = 1;
  PrivateCraft = 2;

  { symboliczne stae statusu }
  TakingOff    = 0;
  Cruising     = 1;
  Landing      = 2;
  OnRamp       = 3;

  { symboliczne stae komunikatw }
  MsgChange    = 0;
  MsgTakeOff   = 1;
  MsgLand      = 2;
  MsgReport    = 3;

type

  Airplane = class
  private
    Name     : string;
    Speed    : Integer;
    Altitude : Integer;
    Heading  : Integer;
    Status   : Integer;
    Kind     : Integer;
    Ceiling  : Integer;
  protected
    procedure TakeOff(Dir : Integer); virtual;
    procedure Land; virtual;
  public
    constructor Create(AName : string; AKind : Integer = Airliner);
    function SendMessage(Msg : Integer; var Response : string;
       Spd : Integer; Dir : Integer; Alt : Integer) : Boolean;
    function GetStatus(var StatusString : string) : Integer; overload; virtual;
    function GetStatus : Integer; overload;
    function GetSpeed : Integer;
    function GetHeading : Integer;
    function GetAltitude : Integer;
    function GetName : string;
  end;

implementation

constructor Airplane.Create(AName : string; AKind : Integer);
begin
  inherited Create;
  Name     := AName;
  Kind     := AKind;
  Status   := OnRamp;
  case Kind of
    Airliner : Ceiling := 35000;
    Commuter : Ceiling := 20000;
    PrivateCraft : Ceiling := 8000;
  end;
end;

procedure Airplane.TakeOff(Dir : Integer);
begin
  Heading := Dir;
  Status  := TakingOff;
end;

procedure Airplane.Land;
begin
  Speed    := 0;
  Heading  := 0;
  Altitude := 0;
  Status   := OnRamp;
end;

function Airplane.SendMessage(Msg : Integer; var Response : string;
   Spd : Integer; Dir : Integer; Alt : Integer) : Boolean;
begin
  Result := True;

  { Wykonanie czynnoci odpowiednich do otrzymanego polecenia }
  case Msg of
    MsgTakeOff :
      { nie mona wystartowa, bdc ju w powietrzu }
      if status <> OnRamp then begin
        Response := Name + ': Jestem ju w powietrzu!';
        Result := False;
      end else
        TakeOff(dir);
    MsgChange :
      begin
        { Check for bad commands and exit if any found. }
        if Spd > 500 then
          Response := 'Command Error: Speed cannot be more than 500.';
        if Dir > 360 then
          Response := 'Command Error: Heading cannot be over 360 degrees.';
        if Alt < 100 then
          Response := Name + ': I''d crash!';
        if Alt > Ceiling then
          Response := Name + ': I can''t go that high.';
        if (Spd = 0) and (Dir = 0) and (Alt = 0) then
          Response := Name + ': Huh?';
        if Response <> '' then begin
          Result := False;
          Exit;
        end;

        { Can't change status if on the ground. }
        if status = OnRamp then begin
          Response := Name + ': I''m on the ground.';
          Result := False;
        end else begin
          Speed := Spd;
          Heading := Dir;
          Altitude := Alt;
          Status := Cruising;
        end;
      end;
    MsgLand :
      { Can't land if already on the ground. }
      if status = OnRamp then begin
        Response := Name + ': I''m already on the ground.';
        Result := False;
      end else
        Land;
    MsgReport :
      begin
        GetStatus(Response);
        Exit;
      end;
  end;

  { Standard reponse if all went well. }
  if Result then
    Response := Name + ': Roger.';
end;

function Airplane.GetStatus(var StatusString : string) : Integer;
begin
  StatusString := Format('%s, Altitude: %d, Heading: %d, ' +
    'Speed: %d', [Name, Altitude, Heading, Speed]);
  Result := Status;
end;

function Airplane.GetStatus : Integer;
begin
  Result := Status;
end;

function Airplane.GetSpeed : Integer;
begin
  Result := Speed;
end;

function Airplane.GetHeading : Integer;
begin
  Result := Heading;
end;

function Airplane.GetAltitude : Integer;
begin
  Result := Altitude;
end;

function Airplane.GetName : string;
begin
  Result := Name;
end;

end.
