unit FlshTstU;
 
interface
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, FlashingLabel;
 
type
  TMainForm = class(TForm)
    FlashBox: TCheckBox;
    Group: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure GroupClick(Sender: TObject);
    procedure FlashBoxClick(Sender: TObject);
  private
    { Private declarations }
    Flasher : TFlashingLabel;
    procedure OnLimitReached(Sender : TObject; var Stop : Boolean);  public
    { Public declarations }
  end;
 
var
  MainForm: TMainForm;
 
implementation
 
{$R *.DFM}
 
procedure TMainForm.FormCreate(Sender: TObject);
begin
  Flasher := TFlashingLabel.Create(Self);
  Flasher.Parent := Self;
  Flasher.SetBounds(20, 20, 200, 20);
  Flasher.Font.Size := 16;
  Flasher.Caption := 'To jest test';
  Flasher.FlashRate := 800;
  Flasher.FlashLimit := 5;
  Flasher.OnLimitReached := OnLimitReached;
end;
 
procedure TMainForm.OnLimitReached(Sender : TObject; var Stop : Boolean);
begin
  { Funkcja obsugujca zdarzenie OnLimitReached. Ustawienie }
  { parametru Stop na True powoduje zatrzymanie migotania, }
  { pozostawienie parametru bez zmian powoduje kontynuacj }
  { migotania. }
  Stop := True;
end;
 
procedure TMainForm.GroupClick(Sender: TObject);
begin
  case Group.ItemIndex of
    0 :  Flasher.FlashRate := 1200;
    1 :  Flasher.FlashRate := 800;
    2 :  Flasher.FlashRate := 400;
    3 :  Flasher.FlashRate := 150;
  end;
end;

procedure TMainForm.FlashBoxClick(Sender: TObject);
begin
  Flasher.FlashEnabled := FlashBox.Checked;
end;

end.

