unit CaptureU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm2 = class(TForm)
    Image: TImage;
    CaptureBtn: TButton;
    Memo: TMemo;
    Panel: TPanel;
    CheckBox: TCheckBox;
    ResultsBtn: TButton;
    procedure CaptureBtnClick(Sender: TObject);
    procedure ResultsBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses Capture2;

{$R *.DFM}

procedure TForm2.CaptureBtnClick(Sender: TObject);
var
  DtCanvas  : TCanvas;
  Bitmap    : TBitmap;
  NumColors : Integer;
  LogPal    : PLogPalette;
  Src, Dst  : TRect;
begin
  { Utwrz obiekt klasy TCanvas reprezentujcy kontekst urzdzenia Pulpitu}
  DtCanvas := TCanvas.Create;
  DtCanvas.Handle := GetDC(0);

  { Utwrz obiekt bitmapy o wymiarach tosamych }
  { z wymiarami formularza }
  Bitmap := TBitmap.Create;
  Bitmap.Width := Width;
  Bitmap.Height := Height;

  { Utwrz palet identycznz palet formularza }
  { i skojarz j z bitmap                      }

  NumColors := GetDeviceCaps(Canvas.Handle, SizePalette);
  GetMem(LogPal, SizeOf(TLogPalette) +
    (NumColors - 1) * SizeOf(TPaletteEntry));
  LogPal.palVersion  := $300;
  LogPal.palNumEntries := NumColors;
  GetSystemPaletteEntries(
    Canvas.Handle, 0, NumColors, LogPal.palPalEntry);
  Bitmap.Palette := CreatePalette(LogPal^);
  FreeMem(LogPal);


  { skopiuj do bitmapy fragment ptna Pulpitu }

  Src := BoundsRect;
  Dst := Rect(0, 0, Width, Height);
  Bitmap.Canvas.CopyRect(Dst, DtCanvas, Src);

  { zapisz skopiowany fragment na dysk }
  Bitmap.SaveToFile('form.bmp');
  { wyczy bitmap }
  Bitmap.Free;
  DtCanvas.Free;
  ResultsBtn.Enabled := True;
end;

procedure TForm2.ResultsBtnClick(Sender: TObject);
begin
  ResultsForm.ShowModal;
end;

end.
