unit EventU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    Memo: TMemo;
    Panel2: TPanel;
    ClearAll: TButton;
    GroupBox1: TGroupBox;
    MouseDown: TCheckBox;
    MouseUp: TCheckBox;
    MouseClick: TCheckBox;
    MouseDblClick: TCheckBox;
    GroupBox2: TGroupBox;
    KeyDown: TCheckBox;
    KeyPress: TCheckBox;
    KeyUp: TCheckBox;
    Panel1: TPanel;
    Timer: TTimer;
    procedure ClearAllClick(Sender: TObject);
    procedure MemoClick(Sender: TObject);
    procedure MemoDblClick(Sender: TObject);
    procedure MemoKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MemoMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MemoMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MemoKeyPress(Sender: TObject; var Key: Char);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}


procedure TMainForm.MemoDblClick(Sender: TObject);
begin
  MouseDblClick.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  KeyDown.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MouseUp.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MouseDown.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  KeyUp.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoKeyPress(Sender: TObject; var Key: Char);
begin
  KeyPress.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.MemoClick(Sender: TObject);
begin
  MouseClick.Checked := True;
  Timer.Enabled := True;
end;

procedure TMainForm.ClearAllClick(Sender: TObject);
var
  I : Integer;
begin
  for I := 0 to Pred(ComponentCount) do
    if Components[I] is TCheckBox then
      with Components[i] as TCheckBox do
        Checked := False;
  ActiveControl := Memo;
  Timer.Enabled := False;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  ClearAllClick(Self);
end;

end.
