unit EHTestU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    RaiseBtn: TButton;
    RadioGroup: TRadioGroup;
    Panel1: TPanel;
    Bevel1: TBevel;
    Label1: TLabel;
    MsgLabel: TLabel;
    procedure RaiseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure DoIt;
    procedure MyOnException(Sender: TObject; E: Exception);
  public
    { Public declarations }
  end;

  { klasa wyjtku zdefiniowana przez uytkownika }
  EMyError = class(Exception);

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.RaiseBtnClick(Sender: TObject);
begin
  { Place the function call to the DoIt function
  { withing a try block. In this case we know that the
  { DoIt function will raise an exception. following
  { the try block are five catch statements which will
  { catch the five types of exceptions that might be
  { raisen by the DoIt function. }

  { umieszczenie wywoania funkcji DoIt w ramach bloku try }
  { powoduje, i powstanie wyjtku w czasie jej realizacji }
  { spowoduje przekazanie sterowania do sekcji except, gdzie
  { rozpoznawany jest typ wyjtku }

  try
    DoIt;
  except
    on EConvertError do begin
      MessageBeep(0);
      MsgLabel.Caption :=
        'Wystpi wyjtek EConvertError';
    end;
    on EZeroDivide do begin
      MessageBeep(0);
      MsgLabel.Caption :=
        'Wystpi wyjtek EZeroDivide';
    end;
    on E : EFOpenError do begin
      MessageBeep(0);
      MsgLabel.Caption := E.Message;
    end;
    on E : EMyError do begin
      MessageBeep(0);
      MsgLabel.Caption := E.Message;
    end;
    on E : EInvalidGraphic do
    begin
      MessageBeep(0);
      MsgLabel.Caption := 'Wyjtek VCL: ' + E.Message;
    end;
  end;
end;

procedure TMainForm.DoIt;
var
  Image : TImage;
  List  : TStringList;
  X     : Integer;
begin

  { wygenerowanie wyjtku stosownie do wybranej opcji }
  case RadioGroup.ItemIndex of
    0 : raise EConvertError.Create('Niewykonalna konwersja');
    1 : raise EZeroDivide.Create('Bdny parametr');
    2 : raise EFOpenError.Create('Nie znaleziono pliku');
    3 : raise EMyError.Create('Nieokrelona przyczyna bdu');
    4 :
      begin
        Image := TImage.Create(Self);
        Image.Picture.LoadFromFile('ehtest.exe');
      end;
    5 :
      { jakakolwiek instrukcja mogca spowodowa wyjtek }
      X := List.Count;
  end;
end;

procedure TMainForm.MyOnException(Sender: TObject; E: Exception);
var
  S : String;
begin
  { niniejsza procedura przechwytuje wszelkie nieobsuone wyjtki}
  { przechwycenie wyjtku sygnalizowane jest wywietleniem komunikatu}
  { o treci zgodnej z opisem wyjtku w ramach VCL }


  S := 'Nieobsuzony wyjtek: ' + E.Message;
  MsgLabel.Caption := S;
  MsgLabel.Refresh;

  Application.ShowException(E);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { ustanowienie domylnej procedury obsugi wyjtkw}
  Application.OnException := MyOnException;
end;

end.
