unit SMTPTstU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Psock, NMsmtp, ComCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    SendBtn: TButton;
    ToEdit: TEdit;
    FromEdit: TEdit;
    SubjectEdit: TEdit;
    Message: TMemo;
    StatusBar: TStatusBar;
    SMTP: TNMSMTP;
    HostLabel: TLabel;
    HostEdit: TEdit;
    procedure SMTPSuccess(Sender: TObject);
    procedure SMTPFailure(Sender: TObject);
    procedure SendBtnClick(Sender: TObject);
    procedure SMTPConnect(Sender: TObject);
    procedure SMTPDisconnect(Sender: TObject);
    procedure SMTPConnectionFailed(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.SMTPSuccess(Sender: TObject);
begin
  StatusBar.SimpleText := 'Wiadomo wysana!';
  SMTP.Disconnect;
  SendBtn.Enabled := True;
end;

procedure TMainForm.SMTPFailure(Sender: TObject);
begin
  StatusBar.SimpleText := 'Bd wysyania poczty';
  SMTP.Disconnect;
end;

procedure TMainForm.SendBtnClick(Sender: TObject);
begin
  SendBtn.Enabled := False;
  SMTP.Connect;
end;

procedure TMainForm.SMTPConnect(Sender: TObject);
begin
  { poczono - wylij wiadomo }
  StatusBar.SimpleText := 'Poczono';
  with SMTP.PostMessage do
  begin
    FromAddress := FromEdit.Text;
    ToAddress.Add(ToEdit.Text);
    Subject := SubjectEdit.Text;
    Body.Assign(Message.Lines);
  end;
  if HostEdit.Text=''
  then
    SMTP.Host := 'mail'
  else
    SMTP.Host := HostEdit.Text;
  SMTP.SendMail;
end;

procedure TMainForm.SMTPDisconnect(Sender: TObject);
begin
  { Zdarzenie OnDisconnect moe wystpi rwnie wtedy, }
  { gdy obiekt, ktry je wygenerowa, ju nie istnieje; }
  { std konieczno poniszego testu}

  if not Assigned(SendBtn)
  then
    Exit;
  SendBtn.Enabled := True;
end;

procedure TMainForm.SMTPConnectionFailed(Sender: TObject);
begin
  SendBtn.Enabled := True;
end;

end.
