
unit CallDLLU;
 
interface
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;
 
type
  TMainForm = class(TForm)
    HelloBtn: TButton;
    OrdBtn: TButton;
    DynamicLoadBtn: TButton;
    NamedBtn: TButton;
    procedure HelloBtnClick(Sender: TObject);
    procedure OrdBtnClick(Sender: TObject);
    procedure DynamicLoadBtnClick(Sender: TObject);
    procedure NamedBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
 
var
  MainForm: TMainForm;
{ Procedura importowana przez nazw }
procedure SayHello(AForm : TForm);
  external 'testdll.dll';
 
{ Procedura importowana przez indeks porzdkowy }
procedure OrdinalProcedure;
  external 'testdll.dll' index 99;
 
{Procedura importowana ze zmian nazwy }
procedure CoolProcedure;
  external 'testdll.dll' name 'DoSomethingReallyCool';
 
implementation
 
{$R *.DFM}
 
procedure TMainForm.HelloBtnClick(Sender: TObject);
begin
  SayHello(Self);
end;
procedure TMainForm.OrdBtnClick(Sender: TObject);
begin
  OrdinalProcedure;
end;
 
procedure TMainForm.DynamicLoadBtnClick(Sender: TObject);
type
  TSayHello = procedure(AForm : TForm);
var
  DLLInstance : THandle;
  SayHello    : TSayHello;
begin
  { Zaadowanie biblioteki DLL }
  DLLInstance := LoadLibrary('DynLoad.dll');
  { Poinformowanie uytkownika, jeeli wczytywanie biblioteki nie powiedzie si. }
  if DLLInstance = 0 then begin
    MessageDlg('Nie mona wczyta moduu DLL.', mtError, [mbOK], 0);
    Exit;
  end;
  { Przypisz adres importowanej funkcji do wskanika }
  @SayHello := GetProcAddress(DLLInstance, 'SayHelloDyn');

  { Wywoanie procedury, jeeli zostanie znaleziona. }
  if @SayHello <> nil then
    SayHello(Self)
  else
    MessageDlg('Nie mona znale procedury.', mtError, [mbOK], 0);
  { Rozaduj bibliotek DLL }
  FreeLibrary(DLLInstance);
end;

procedure TMainForm.NamedBtnClick(Sender: TObject);
begin
  CoolProcedure;
end;

end.


