unit MakeTxtU;
 
interface
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DbTables;
 
type
  TForm1 = class(TForm)
    CreateBtn: TButton;
    Memo: TMemo;
    procedure CreateBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
 
var
  Form1: TForm1;
 
implementation
 
{$R *.DFM}
 
procedure TForm1.CreateBtnClick(Sender: TObject);
var
  Table : TTable;
  S     : string;
begin
 { Utworzenie obiektu Table oraz przypisanie mu nazwy bazy }
 { danych i nazwy tabeli. }
  Table := TTable.Create(Self);
  Table.DatabaseName := 'DBDEMOS';
  Table.TableName := 'Customer.db';
 
  { Zmiana kursora na klepsydr. }
  Screen.Cursor := crHourGlass;
 
  { Mona uy komponentu Memo do pokazania postpu zadania}
  { i jednoczenie zapisania pliku na dysk. Najpierw obiekt }
  { Memo musi zosta wyczyszczony z wszelkiego tekstu. }
 
  Memo.Lines.Clear;
 
  { Otwarcie tabeli. }
  Table.Active := True;
  CreateBtn.Enabled := False;
 
  { Ptla zapisujca kolejne rekordy do komponentu Memo. }
  while not Table.Eof do begin
 
    { Pobranie pierwszego pola i dodanie go do acucha S, }
    { umieszczenie na kocu acucha znaku przecinka. }
    S := Table.FieldByName('CustNo').AsString + ',';
    { Powtrzenie identycznego kroku dla wszystkich (wymaganych
    { przez nas) pl. }
    S := S + Table.FieldByName('Company').AsString + ',';
    S := S + Table.FieldByName('Addr1').AsString + ',';
    S := S + Table.FieldByName('Addr2').AsString + ',';
    S := S + Table.FieldByName('City').AsString + ',';
    S := S + Table.FieldByName('State').AsString + ',';
    S := S + Table.FieldByName('Zip').AsString + ',';
    S := S + Table.FieldByName('Phone').AsString + ',';
    S := S + Table.FieldByName('FAX').AsString + ',';
 
    { Dodanie acucha do komponentu Memo. }
    Memo.Lines.Add(S);
 
    { Przejcie do kolejnego rekordu. }
    Table.Next;
  end;
 
  { Zapisanie zawartoci komponentu Memo do pliku tekstowego }
  Memo.Lines.SaveToFile('customer.txt');
 
{ Przywrcenie poprzedniego kursora i jego ponowne udostpnienie }
  CreateBtn.Enabled := True;
  Screen.Cursor := crDefault;
  Table.Free;
end;

end.



