unit DbQueryU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, Grids, DBGrids;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    DBNamesComboBox: TComboBox;
    TablesComboBox: TComboBox;
    DBGrid1: TDBGrid;
    ValueEdit: TEdit;
    FindBtn: TButton;
    FieldsComboBox: TComboBox;
    SQLEdit: TEdit;
    SQLBtn: TButton;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    UserNameEdit: TEdit;
    PasswordEdit: TEdit;
    DataSource1: TDataSource;
    Database1: TDatabase;
    Query1: TQuery;
    procedure DBNamesComboBoxChange(Sender: TObject);
    procedure TablesComboBoxChange(Sender: TObject);
    procedure SQLBtnClick(Sender: TObject);
    procedure FindBtnClick(Sender: TObject);
    procedure Database1Login(Database: TDatabase; LoginParams: TStrings);
    procedure SQLEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.DBNamesComboBoxChange(Sender: TObject);
var
  DBName : string;
begin
  if Query1.Active then
    Query1.Active := False;
  if Database1.Connected then
    Database1.Close;
  TablesComboBox.Text := '';
  DBName := DBNamesComboBox.Text;
  Database1.DatabaseName := DBName;
  if Database1.IsSQLBased then
    Session.GetTableNames(DBName, '',
      False, True, TablesComboBox.Items)
  else
    Session.GetTableNames(DBName, '',
      True, False, TablesComboBox.Items);
  Query1.DatabaseName := DBName;
  TablesComboBox.DroppedDown := True;
end;

procedure TMainForm.TablesComboBoxChange(Sender: TObject);
var
  S : string;
begin
  if TablesComboBox.Text = '' then
    Exit;
  S := 'Select * from ' + TablesComboBox.Text;
  Query1.SQL.Clear;
  Query1.SQL.Add(S);
  Query1.Open;
  FieldsComboBox.Enabled := True;
  ValueEdit.Enabled := True;
  Query1.GetFieldNames(FieldsComboBox.Items);
  FieldsComboBox.Text := FieldsComboBox.Items.Strings[0];
end;

procedure TMainForm.SQLBtnClick(Sender: TObject);
begin
  Query1.SQL.Clear;
  Query1.SQL.Add(SQLEdit.Text);
  Query1.Open;
end;

procedure TMainForm.FindBtnClick(Sender: TObject);
var
  SearchOptions : TLocateOptions;
begin
  SearchOptions := [loPartialKey];
  Query1.Locate(FieldsComboBox.Text, ValueEdit.Text, SearchOptions);
end;

procedure TMainForm.Database1Login(Database: TDatabase;
  LoginParams: TStrings);
begin
  LoginParams.Values['user name'] := UserNameEdit.Text;
  LoginParams.Values['password'] := PasswordEdit.Text;
end;

procedure TMainForm.SQLEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then begin
    SQLBtnClick(Sender);
    SQLEdit.SelectAll;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Session.GetDatabaseNames(DBNamesComboBox.Items);
end;

end.
