unit RegTestU;
 
interface
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, ExtCtrls, Registry;
 
type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    DeleteKey: TButton;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    TimeLabel: TLabel;
    DateLabel: TLabel;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    FileOpen: TMenuItem;
    FileExit: TMenuItem;
    OpenDialog: TopenDialog;
    procedure FormCreate(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileExitClick(Sender: TObject);
    procedure DeleteKeyClick(Sender: TObject);
  private
    { Private declarations }
    KeyDeleted : Boolean;
  public
    { Public declarations }
  end;
 
var
  MainForm: TMainForm;
 
implementation
 
{$R *.DFM}
 
procedure TMainForm.FormCreate(Sender: TObject);
var
  Reg       : TRegistry;
  KeyGood   : Boolean;
  DT        : TDateTime;
  Top       : Integer;
  Left      : Integer;
  Width     : Integer;
  Height    : Integer;
begin
   
    {Zainicjalizowanie zmiennej KeyDeleted wartoci False. 
    {Zmienna ta jest ustawiana, gdy uytkownik usunie klucz 
    {w programie. Patrz funkcja FormDestroy  }
  KeyDeleted := False;
 
    {Utworzenie obiektu klasy TRegistry, aby uzyska dostp do
    {Rejestru    }
  Reg := TRegistry.Create;
 
  try
        {Otwarcie klucza}
    KeyGood := Reg.OpenKey(
      'Software\SAMS\Delphi 6 in 21 Days', False);
 
        {Sprawdzenie, czy klucz zosta utworzony. Jeeli nie,
        {oznacza to, e program zosta uruchomiony po raz pierwszy,
        {nie ma wic adnych operacji do wykonania. }
        {Jeeli klucz istnieje, wtedy odczytywane s z niego
        {wszystkie pola danych potrzebne przy starcie aplikacji.}
 
    if KeyGood then begin
      Top := Reg.ReadInteger('Top');
      Left := Reg.ReadInteger('Left');
      Width := Reg.ReadInteger('Width');
      Height := Reg.ReadInteger('Height');
      SetBounds(Left, Top, Width, Height);
      WindowState :=
        TWindowState(Reg.ReadInteger('WindowState'));
 
         {Jeeli niezbdne s operacje na czasie i dacie, 
         {doskonale nadaje si do tego obiekt klasy TDateTime }
      DT := Reg.ReadDate('Date and Time');
      DateLabel.Caption := DateToStr(DT);
      TimeLabel.Caption := TimeToStr(DT);
    end;
  finally
    Reg.Free;
  end;
end;
 
procedure TMainForm.FileOpenClick(Sender: TObject);
var
  Reg      : TRegistry;
begin
 
  {Funkcja ta wywietla okno dialogowe Otwrz, ale 
  {w rzeczywistoci nie powoduje otwarcia pliku. Ostatnia
  {cieka, filtr i nazwa pliku s zapisywane w rejestrze
  {w chwili, gdy uytkownik nacinie przycisk OK. }
  {Utworzenie obiektu klasy TRegistry, aby uzyska dostp do
    {Rejestru    }
  Reg := TRegistry.Create;
 
  try
      {Otwarcie klucza}
    Reg.OpenKey('Software\SAMS\Delphi 6 in 21 Days', True);
 
      {Czytanie wartoci po wczeniejszym sprawdzeniu ich 
        {istnienia }
    if Reg.ValueExists('LastDir') then
      OpenDialog.InitialDir := Reg.ReadString('LastDir');
    if Reg.ValueExists('LastFile') then
      OpenDialog.FileName := Reg.ReadString('LastFile');
    if Reg.ValueExists('FilterIndex') then
      OpenDialog.FilterIndex := Reg.ReadInteger('FilterIndex');
 
        {Wywietlenie okna dialogowego Otwrz. Jeeli uytkownik
        {nacinie przycisk OK, wtedy cieka dostpu, plik 
        { i uywany filtr zapisane zostan w rejestrze }
    if OpenDialog.Execute then begin
      Reg.WriteString('LastDir',
        ExtractFilePath(OpenDialog.FileName));
      Reg.WriteString('LastFile',
        ExtractFileName(OpenDialog.FileName));
      Reg.WriteInteger
        ('FilterIndex', OpenDialog.FilterIndex);
    end;
  finally
    Reg.Free;
  end;
end;
 
procedure TMainForm.FormDestroy(Sender: TObject);
var
  Reg       : TRegistry;
begin
    {Jeeli uytkownik nacisn przycisk usuwajcy klucz,
    {wtedy przestaje istnie potrzeba zapisania informacji }
  if KeyDeleted then
    Exit;
 
    {Utworzenie obiektu klasy TRegistry, aby uzyska dostp do
    {Rejestru	}
  Reg := TRegistry.Create;
 
  try
        {Otwarcie klucza}
    Reg.OpenKey(
      'Software\SAMS\Delphi 6 in 21 Days', True);
        {Wpisanie odpowiednich wartoci}
    Reg.WriteInteger('WindowState', Ord(WindowState));
    if WindowState <> wsMaximized then begin
      Reg.WriteInteger('Top', Top);
      Reg.WriteInteger('Left', Left);
      Reg.WriteInteger('Width', Width);
      Reg.WriteInteger('Height', Height);
    end;
    Reg.WriteDate('Date and Time', Now);
  finally
    Reg.Free;
  end;
end;
 
procedure TMainForm.FileExitClick(Sender: TObject);
begin
  Close;
end;
 
procedure TMainForm.DeleteKeyClick(Sender: TObject);
var
  Reg       : TRegistry;
begin
    {Uytkownik nacisn przycisk umieszczony na formularzu,
    {klucz zostaje usunity. Znacznik usunicia klucza zostaje
    {ustawiony, aby nie nastpio jego ponowne utworzenie
    {podczas zamykania formularza }
  Reg := TRegistry.Create;
  try
    Reg.DeleteKey('Software\SAMS');
    KeyDeleted := True;
  finally
    Reg.Free;
  end;
end;

end.



