unit MessageU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

const
  My_Message = WM_USER + 1;

type
  TMainForm = class(TForm)
    ShowTBoix: TButton;
    GroupBox1: TGroupBox;
    Hatched: TCheckBox;
    LetVCLHandle: TCheckBox;
    Instructions: TButton;
    procedure InstructionsClick(Sender: TObject);
    procedure ShowTBoixClick(Sender: TObject);
    procedure HatchedClick(Sender: TObject);
  private
    { Private declarations }
  procedure WmNCHitTest(var Msg : TWMNCHitTest); message WM_NCHITTEST;
  procedure WmEraseBkgnd(var Msg : TWMEraseBkgnd); message WM_ERASEBKGND;
  procedure WmGetMinMaxInfo(var Msg : TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
  procedure MyMessage(var Msg : TMessage); message My_Message;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses ToolBoxU, InstrctU;

{$R *.DFM}

procedure TMainForm.InstructionsClick(Sender: TObject);
begin
  { wywietl instrukcj obsugi programu }
  InstructForm.ShowModal;
end;

procedure TMainForm.ShowTBoixClick(Sender: TObject);
begin
  { wywietl palet narzdzi }
  ToolBox.Show;
end;

procedure TMainForm.HatchedClick(Sender: TObject);
begin

  { odwie to w przypadku zmiany stanu ktrejkolwiek opcji }
  Repaint;

  { uaktualnij wskanik okrelajcy posta ta }

  if Sender = LetVCLHandle then
    Hatched.Enabled := not LetVCLHandle.Checked;
end;

procedure TMainForm.WmEraseBkgnd(var Msg: TWMEraseBkgnd);
var
  Canvas : TCanvas;
begin

  { niniejsza procedura obsuguje komunikat WM_ERASEBKGND }
  { jeeli zaznaczone jest pole wyboru "Domylna obsuga..." }
  { sterowanie przekazywane jest do procedury wykonujcej domyln }
  { obsug komunikatu }

  if LetVCLHandle.Checked then
  begin
    DefaultHandler(Msg);
    Exit;
  end;


  { struktura danych niesionych przez komunikat TWMEraseBkgnd }
  { zawiera kontekst urzdzenia; kontekst ten obudowywany jest }
  { tworzonym doranie obiektem ptna }

  Canvas := TCanvas.Create;
  with Canvas do
  begin
    Handle := Msg.DC;
    if Hatched.Checked then
      Brush.Handle := CreateHatchBrush(HS_DIAGCROSS, clMaroon)
    else
      Brush.Color := clMaroon;
    FillRect(ClientRect);
    Msg.Result := 1;
    Free;
  end;
end;

procedure TMainForm.WmGetMinMaxInfo(var Msg: TWMGetMinMaxInfo);
begin

  { niniejsza procedura obsuguje komunikat WM_GETMINMAXINFO }
  { ponisze pola komunikatu odpowiadaj waciwoi Constraints }
  { komponentu - narzucenie im sztywnych wartoci powoduje, e }
  { rozmiary okna mog zmienia si jedynie w ramach okrelonych granic }


  Msg.MinMaxInfo.ptMaxTrackSize.x := 500;
  Msg.MinMaxInfo.ptMaxTrackSize.y := 360;
  Msg.MinMaxInfo.ptMinTrackSize.x := 360;
  Msg.MinMaxInfo.ptMinTrackSize.y := 260;
  Msg.Result := 0;
end;

procedure TMainForm.MyMessage(var Msg: TMessage);
var
  S : string;
begin

  { niniejsza procedura obsuguje komunikat zdefiniowany przez uytkownika }
  { powoduje ona wywietlenie tekstu wskazywanego przez pole WParam }
  { i wyemitowanie krtkiego sygnau dwikowego }


  S := 'Otrzymano komunikat uytkownika!!' + #13 +
    'Nacinito przycisk: ' + PChar(Msg.WParam);
  MessageBeep(0);
  MessageDlg(S, mtInformation, [mbOk], 0);
end;

procedure TMainForm.WmNCHitTest(var Msg: TWMNCHitTest);
begin

  { niniejsza procedura obsuguje komunikat WM_NCHITTEST }
  { obsuga ta jest w istocie wzbogaceniem standardowej obsugi }
  { o "zafaszowanie" informacji dotyczcej miejsca kliknicia - }
  { kliknicie w dowolne miejsce ta "przeadresowywane" jest }
  { do paska tytuowego }


  DefaultHandler(Msg);
  if Msg.Result = HTCLIENT
  then
    Msg.Result := HTCAPTION;
end;

end.
