unit StatBarU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    OvrMode: TCheckBox;
    ExtendedSel: TCheckBox;
    Simple: TCheckBox;
    procedure StatusBarDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure SimpleClick(Sender: TObject);
    procedure OvrModeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.StatusBarDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var
  R : TRect;
  Icon : HIcon;
begin
  with StatusBar.Canvas do
  begin

    { utwrz roboczy object TRect; jego parametry nie bd zmieniane }
    R := Rect;
    { sprawd, czy rysowanie dotyczy trzeciego panelu; }
    { jesli tak, narysuj na panelu ikon               }

    if Panel.Index = 3 then
    begin
        { zaaduj standardow ikon Windows}
        Icon := LoadIcon(0, IDI_HAND);

        { Narysuj ikon zmniejszon do rozmiaru 15 x 15 pikseli }
        { i wyrodkowan w pionie}
        DrawIconEx(Handle, Rect.Left + 6, 3,
          Icon, 15, 15, 0, 0, DI_NORMAL);

        Exit;
    end;
    { This rather lengthy if statement checks to see if
    { either the Overtype Mode or Extended Selection
    { check boxes are checked. If so, then what we need
    { to do is to draw the text twice. First, we draw it
    { in white. Then we draw it again, offset by 1 pixel,
    { in gray. The effect is a 3D disabled-text look. }

    { ponisza sekwencja powoduje wypisanie (pod pewnymi warunkami) }
    { tekstu o symulowamym wygldzie trjwymiarowym. Efekt ten osiga si}
    { przez dwukrotne wypisanie tego samego tekstu - najpierw w kolorze biaym,}
    { nastpnie w kolorze szarym z jednoczesnym przesuniciem o 1 piksel w lewo}
    { i 2 piksele w d }



    if ((Panel.Index = 1) and (OvrMode.Checked = False)) or
      ((Panel.Index = 2) and (ExtendedSel.Checked = False)) then
    begin

      Inc(R.Left);
      Inc(R.Top, 2);

      Font.Color := clWhite;

      { ustaw "przezroczysty" styl pdzla, by tekst wypisywany jako }
      { drugi nie przesoni tekstu ju wypisanego }

      Brush.Style := bsClear;
      { Draw the text using the API function DrawText. }
      { I use DrawText because it allows me to center
      { the text both horizontally and vertically within
      { the given rectangle. }

      { wywietl tekst w pooeniu centralnym w stosunku do }
      { zdefiniowanego prostokta }

      DrawText(Handle, PChar(Panel.Text), -1,
        R, DT_CENTER or DT_VCENTER or DT_SINGLELINE);

      Font.Color := clGray;

      { przywr oryginalny rozmiar prostokta}
      Dec(R.Left);
      Dec(R.Top, 2);
    end;

    { jeeli element jest niedostpny, pozostaw wypisany tekst }
    { w symulowanej postaci trjwymiarowej; w przeciwnym razie }
    { wypisz tekst w kolorze czarnym}
    DrawText(Handle, PChar(Panel.Text), -1,
      R, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
  end;
end;

procedure TMainForm.SimpleClick(Sender: TObject);
begin
  { ustaw typ paska stosownie do pola opcji }
  StatusBar.SimplePanel := Simple.Checked;
end;

procedure TMainForm.OvrModeClick(Sender: TObject);
begin
  { odwie wygld panelu po zmianie trybu }
  StatusBar.Repaint;
end;

end.
