unit SPMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, ComCtrls, ToolWin,
  ImgList, ClipBrd, ActnList, StdActns, Printers;

type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    Memo: TMemo;
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    FileNew: TMenuItem;
    FileOpen: TMenuItem;
    FileSave: TMenuItem;
    FileSaveAs: TMenuItem;
    N1: TMenuItem;
    FilePrint: TMenuItem;
    FilePrintSetup: TMenuItem;
    N2: TMenuItem;
    FileExit: TMenuItem;
    Edit1: TMenuItem;
    EditReplace: TMenuItem;
    EditFind: TMenuItem;
    N4: TMenuItem;
    EditPaste: TMenuItem;
    EditCopy: TMenuItem;
    EditCut: TMenuItem;
    N5: TMenuItem;
    EditUndo: TMenuItem;
    Help1: TMenuItem;
    HelpAbout: TMenuItem;
    HelpContents: TMenuItem;
    EditSelectAll: TMenuItem;
    N3: TMenuItem;
    EditWordWrap: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    MemoPopup: TPopupMenu;
    PopupCut: TMenuItem;
    PopupCopy: TMenuItem;
    PopupPaste: TMenuItem;
    CoolBar: TCoolBar;
    ImageList: TImageList;
    ActionList: TActionList;
    CopyAction: TEditCopy;
    CutAction: TEditCut;
    PasteAction: TEditPaste;
    MainToolBar: TToolBar;
    FileNewBtn: TToolButton;
    FileOpenBtn: TToolButton;
    FileSaveBtn: TToolButton;
    ToolButton1: TToolButton;
    EditCutBtn: TToolButton;
    EditCopyBtn: TToolButton;
    EditPasteBtn: TToolButton;
    ToolButton4: TToolButton;
    HelpAboutBtn: TToolButton;
    SaveAction: TAction;
    PrintDialog: TPrintDialog;
    PrinterSetupDialog: TPrinterSetupDialog;
    SaveAsAction: TAction;
    procedure FileExitClick(Sender: TObject);
    procedure EditCutClick(Sender: TObject);
    procedure EditCopyClick(Sender: TObject);
    procedure EditPasteClick(Sender: TObject);
    procedure FileNewClick(Sender: TObject);
    procedure FileSaveClick(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FileSaveAsClick(Sender: TObject);
    procedure EditUndoClick(Sender: TObject);
    procedure EditSelectAllClick(Sender: TObject);
    procedure EditWordWrapClick(Sender: TObject);
    procedure HelpAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FilePrintSetupClick(Sender: TObject);
    procedure FilePrintClick(Sender: TObject);
    procedure SaveActionUpdate(Sender: TObject);
  private
    { Private declarations }
    procedure MyOnHint(Sender : TObject);
    procedure PrintFooter(var R : TRect; LineHeight : Integer);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses SPAbout;

{$R *.DFM}

procedure TMainForm.FileExitClick(Sender: TObject);
begin
  { koniec pracy, zamknij formularz }
  Close;
end;

procedure TMainForm.EditCutClick(Sender: TObject);
begin
  Memo.CutToClipboard;
end;

procedure TMainForm.EditCopyClick(Sender: TObject);
begin
  Memo.CopyToClipboard;
end;

procedure TMainForm.EditPasteClick(Sender: TObject);
begin
  Memo.PasteFromClipboard;
end;



procedure TMainForm.FileNewClick(Sender: TObject);
var
  Res : Integer;
begin
  { Zresetuj zawarto Memo sprawdziwszy uprzednio, czy zachowane zostay ewentualne zmiany }
  if Memo.Modified then begin
    { wywietl komunikat }
    Res := Application.MessageBox(
      'Czy zachowa wprowadzone zmiany?',
      'Scratch', MB_YESNOCANCEL);

     if Res = IDYES then
       FileSaveClick(Sender); {zachowaj biec zawarto}

    if Res = IDCANCEL then   ; {nic nie rb}
      Exit;
  end;
  { usu ca zawarto Memo }
  if Memo.Lines.Count > 0 then
    Memo.Clear;
  { Wyczy waciwo FileName okna "Zapisz..." }
  { Stanowi to sygna, i zawarto Memo nie bya jeszcze zapisywana }
  SaveDialog.FileName := '';
end;

procedure TMainForm.FileOpenClick(Sender: TObject);
var
  Res : Integer;
begin
  { Otwrz plik sprawdziwszy uprzednio, czy zachowane zostay ewentualne zmiany }
  if Memo.Modified then begin

    Res := Application.MessageBox(
      'Czy zachowa wprowadzone zmiany?',
      'Scratch', MB_YESNOCANCEL);

    if Res = IDYES then
      FileSaveClick(Sender);
    if Res = IDCANCEL then
      Exit;
  end;
  { Wykonaj dialog otwarcia pliku - po klikniciu w przycisk OK }
  { wczytaj zawartos pliku za pomoc metody LoadFromFile }

  OpenDialog.FileName := '';
  if OpenDialog.Execute then begin
    if Memo.Lines.Count > 0 then
      Memo.Clear;
    Memo.Lines.LoadFromFile(OpenDialog.FileName);
    SaveDialog.FileName := OpenDialog.FileName;
  end;
end;

procedure TMainForm.FileSaveClick(Sender: TObject);
begin

  { Jeeli zawarto Memo bya ju zapisywana, nie ma potrzeby }
  { pytania o nazw pliku }

  if SaveDialog.FileName <> '' then
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);

    { Zaznacz fakt zapisania zmian }
    Memo.Modified := False;

  end
  else
    { zapisanie zawartoci poprzedzone pobraniem nazwy pliku }
    FileSaveAsClick(Sender);

end;


procedure TMainForm.FileSaveAsClick(Sender: TObject);
begin
  { zapisanie zawartoci poprzedzone pobraniem nazwy pliku }
  SaveDialog.Title := 'Zapisz jako';
  if SaveDialog.Execute then
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);
    { Zaznacz fakt zapisania zmian }
    Memo.Modified := False;
  end;
end;


procedure TMainForm.EditUndoClick(Sender: TObject);
begin
  { Komponent TMemo nie posiada metody umoliwiajcej cofanie }
  { wykonywanych operacji; czynno t naley wykonywa za pomoc }
  { komunikatu WM_UNDO }
  SendMessage(Memo.Handle, WM_UNDO, 0, 0);
end;

procedure TMainForm.EditSelectAllClick(Sender: TObject);
begin
  Memo.SelectAll;
end;

procedure TMainForm.EditWordWrapClick(Sender: TObject);
begin
  { przecz waciwo Memo odpowiedzialn za zawijanie wierszy }
  { i ustaw zgodnie z ni stosowne pole opcji }

  Memo.WordWrap := not Memo.WordWrap;
  EditWordWrap.Checked := Memo.WordWrap;

  { jeeli wczono zawijanie wierszy, nie jest potrzebny poziomy pasek
    przewijania }

  if Memo.WordWrap
  then
    Memo.ScrollBars := ssVertical
  else
    Memo.ScrollBars := ssBoth;
end;


procedure TMainForm.HelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.MyOnHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := MyOnHint;
end;

procedure TMainForm.FilePrintSetupClick(Sender: TObject);
begin
  PrinterSetupDialog.Execute;
end;

procedure TMainForm.PrintFooter(var R: TRect; LineHeight: Integer);
var
  S : String;
begin
  with Printer do begin

    { utwrz acuch zawierajcy numer strony }
    S := Format('Page %d', [PageNumber]);


    { ustal wsprzdne prostokta, ktrym wywietlany bdzie acuch }
    { zawierajcy numer strony }

    R.Top := PageHeight - (lineHeight * 2);
    R.Bottom := R.Top + lineHeight;


    { wywietl centrycznie acuch zawierajcy numer strony }
    DrawText(Handle, PChar(S), -1, R, DT_CENTER);

    { podkrel tekst zawierajcy numer strony }
    Canvas.MoveTo(0, R.Top - 2);
    Canvas.LineTo(R.Right, R.Top - 2);
  end;
end;

procedure TMainForm.FilePrintClick(Sender: TObject);
var
  I            : Integer;
  LineHeight   : Integer;
  LinesPerPage : Integer;
  LineCount    : Integer;
  R            : TRect;
  S            : string;
begin
  { wywietl dialog drukowania }
  if PrintDialog.Execute then begin

    { ustal tytu drukowanego obiektu }
    Printer.Title := 'Scratch - ' + OpenDialog.FileName;

    { ustaw czcionk drukarkow zgodnie z czcionk Memo }
    Printer.Canvas.Font := Memo.Font;



    { Oblicz wysoko linii - na podstawie rozmiaru czcionki }
    { i rozdzielczoci drukarki. Dodaj 40% na odstp midzy liniami }

    LineHeight := Abs(
      MulDiv(Printer.Canvas.Font.Size,
      GetDeviceCaps(Printer.Handle, LOGPIXELSY), 72));
    Inc(LineHeight, (LineHeight * 4) div 10);

    { oblicz, ile linii zmieci si na stronie; uwzgldnij }
    { trjliniowy margines                                 }

    LinesPerPage := (Printer.PageHeight div lineHeight) - 4;

    { rozpocznij drukowanie w 4. linii, by zostawi miejsce }
    { na nagwek }
    LineCount := 4;

    { wydrukuj nagwek }
    Printer.BeginDoc;
    R.Top    := LineHeight;
    R.Left   := 20;
    R.Right  := Printer.PageWidth;
    R.Bottom := LineHeight * 2;
    DrawText(Printer.Handle,
      PChar(OpenDialog.FileName), -1, R, DT_CENTER);

    { drukowanie poszczeglnych linii }
    for I := 0 to Pred(Memo.Lines.Count) do
    begin

      { po dojciu do koca strony zresetuj licznik linii }
      { i przejd do nowej strony                         }

      Inc(LineCount);
      if LineCount = LinesPerPage then begin
        PrintFooter(R, LineHeight);
        LineCount := 4;
        Printer.NewPage;
      end;

      { pobierz kolejn lini Memo }
      S := Memo.Lines.Strings[I];
      Printer.Canvas.TextOut(0, LineCount * LineHeight, S);
    end;

    { zakocz drukowanie }
    PrintFooter(R, LineHeight);
    Printer.EndDoc;
  end;
end;

procedure TMainForm.SaveActionUpdate(Sender: TObject);
begin
  { akcja zwizana z poleceniami "zapisz" i "zapisz jako" }
  SaveAction.Enabled :=
    Memo.Modified and (Length(Memo.Lines.Text) > 0);
  SaveAsAction.Enabled := SaveAction.Enabled;


  { opcje "wybierz wszystkie" i "cofnij" nie korzystaj }
  { z akcji, lecz ustawiane s na podstawie biecego stanu Memo }


  EditSelectAll.Enabled := Memo.Lines.Count > 0;

  EditUndo.Enabled := Memo.Modified;
end;

end.
