unit RotateU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    AngleEdit: TEdit;
    Button: TButton;
    Button1: TButton;
    Button2: TButton;
    procedure FormPaint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ButtonClick(Sender: TObject);
  private
    { Private declarations }
    Angle : Integer;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormPaint(Sender: TObject);
var
  LF : TLogFont;
begin
  { ustal rozsdny rozmiar czcionki }
  Canvas.Font.Size := 20;

  { wypenij struktur LOGFONT }
  GetObject(Canvas.Font.Handle, SizeOf(TLogFont), @lf);

  { ustaw poszczeglne waciwoci wywietlanej czcionki }
  lf.lfEscapement := Angle;
  lf.lfOrientation := Angle;
  lf.lfOutPrecision := OUT_TT_ONLY_PRECIS;

  { utwrz now czcionk i przypisz j do ptna formularza}
  Canvas.Font.Handle := CreateFontIndirect(LF);

  { ponisza instrukcja daje efekt tylko w Windows NT }
  SetGraphicsMode(Canvas.Handle, GM_ADVANCED);

  { ustaw "czyszczcy" styl pdzla }
  Canvas.Brush.Style := bsClear;

  { wypisz tekst centrycznie na formularzu }
  Canvas.TextOut(
    (Width + 100) div 2, Height div 2, 'Pozdrowienia!');
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  I : Integer;
begin
  for I := 0 to 359 do begin
    Angle := I * 10;
    Refresh;
  end;
  Angle := 0;
  Refresh;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Angle := 450;
end;

procedure TMainForm.Button2Click(Sender: TObject);
var
  I : Integer;
  J : Integer;
begin
  J := 0;
  for I :=0 to 90 do begin
    Angle := J * 10;
    InvalidateRect(Handle, nil, False);
    Application.ProcessMessages;
    Inc(J, 4);
  end;
end;

procedure TMainForm.ButtonClick(Sender: TObject);
begin
  Angle := StrToIntDef(AngleEdit.Text, 450) * 10;
  Refresh;
end;

end.
