unit MemBmpU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

const
  DisplayText = 'TurboPower Software Co.';

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    Done : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  I : Integer;
begin
  Canvas.Font.Name := 'Arial Bold';
  Canvas.Font.Size := 16;
  Canvas.Brush.Color := clSilver;
  Done := false;
  while not Done do begin
    for I := -Canvas.TextWidth(DisplayText) to Pred(Width) do begin
      Sleep(1);
      Application.ProcessMessages;
      if (Done) then
        Break;
      Canvas.Font.Color := clGray;
      Canvas.Brush.Style := bsClear;
      Canvas.TextOut(i + 2, 12, DisplayText);
      Canvas.Font.Color := clBlack;
      Canvas.Brush.Style := bsClear;
      Canvas.TextOut(i, 10, DisplayText);
      Canvas.Font.Color := clSilver;
      Canvas.TextOut(i + 2, 12, DisplayText);
      Canvas.TextOut(i, 10, DisplayText);
    end;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Bitmap : TBitmap;
  I : Integer;
begin
  Bitmap := TBitmap.Create;
  Bitmap.Width := Width;
  Bitmap.Height := 40;
  Bitmap.Canvas.Font.Name := 'Arial Bold';
  Bitmap.Canvas.Font.Size := 16;
  Bitmap.Canvas.Brush.Color := clSilver;
  Bitmap.Canvas.FillRect(Rect(0, 0, Width, 40));
  Done := False;
  while not Done do begin
    for I := -Bitmap.Canvas.TextWidth(DisplayText) to Pred(Width) do begin
      Application.ProcessMessages;
      if (Done) then
        Break;
      Sleep(1);
      Bitmap.Canvas.Font.Color := clGray;
      Bitmap.Canvas.Brush.Style := bsClear;
      Bitmap.Canvas.TextOut(2, 12, DisplayText);
      Bitmap.Canvas.Font.Color := clBlack;
      Bitmap.Canvas.Brush.Style := bsClear;
      Bitmap.Canvas.TextOut(0, 10, DisplayText);
      Canvas.Draw(I, 0, Bitmap);
    end;
  end;
  Bitmap.Free;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Done := True;
end;

end.
