unit GrdientU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    Label2: TLabel;
    Label1: TLabel;
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormPaint(Sender: TObject);
const
  Num = 64;
var
  Bitmap : TBitmap;
  I, Size : Integer;

  { Tablica kolorw }
  Colors : array [0..Num - 1] of TColor;
  LogPal : PLogPalette;
  Pal : HPalette;
  R : TRect;
begin
  { utwrz bitmap pamiciow }
  Bitmap := TBitmap.Create;
  Bitmap.Width := Width;
  Bitmap.Height := Height;

  { utwrz palet z 64 odcieniami bkitu. Jest to konieczne tylko wwczas, }
  { gdy biecy tryb wywietlania operuje nie wicej ni 256 kolorami }


  GetMem(LogPal, (SizeOf(TLogPalette) +
    (Num - 1) * SizeOf(TPaletteEntry)));
  LogPal.palVersion := $300;
	for I := 0 to Pred(Num) do begin
		LogPal.palPalEntry[i].peBlue := I * (256 div Num);
  	LogPal.palPalEntry[i].peRed := 0;
  	LogPal.palPalEntry[i].peGreen := 0;
		LogPal.palPalEntry[i].peFlags := 0;

    { Dodaj kolor do tablicy i ustaw najbardziej znaczcy bajt }
    { na warto 2 w celu zaznaczenia, e kolor pochodzi }
    { z palety logicznej                                 }

    colors[Num - I - 1] :=
      TColor(RGB(0, 0, I * (256 div Num)) or $02000000);
	end;
  Pal := CreatePalette(LogPal^);

  { skojarz utworzon palet z bitmap }
  Bitmap.Palette := Pal;

  { narysuj dan liczb wstg, kada w innym odcieniu }
  { (zgodnie z tablic kolorw)                         }
	Size := (ClientHeight div Num) + 1;
	for I := 0 to Pred(Num) do begin
		R := Rect(0, I * Size, ClientWidth, (I * Size) + Size);
    Bitmap.Canvas.Brush.Color :=   Colors[I];
		Bitmap.Canvas.FillRect(R);
	end;

  { kopiuj bitmap pamiciow na ptno formularza }
  Canvas.Draw(0, 0, Bitmap);

  { wyczy bitmap pamiciow }
  Bitmap.Free;
  FreeMem(LogPal);
end;

end.
