unit AVIPlayU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MPlayer;

type
  TMainForm = class(TForm)
    OpenBtn: TButton;
    OpenDialog: TOpenDialog;
    MediaPlayer: TMediaPlayer;
    AVIPanel: TPanel;
    RadioGroup: TRadioGroup;
    StretchCB: TCheckBox;
    procedure OpenBtnClick(Sender: TObject);
    procedure MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure RadioGroupClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.OpenBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    MediaPlayer.FileName := OpenDialog.FileName;
    MediaPlayer.Open;
  end;
end;

procedure TMainForm.MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  if Button = btPlay then begin
    if RadioGroup.ItemIndex = 0 then
      MediaPlayer.Display := nil
    else
      MediaPlayer.Display := AVIPanel;
    if StretchCB.Checked then
      MediaPlayer.DisplayRect := AVIPanel.ClientRect;
  end;      
end;

procedure TMainForm.RadioGroupClick(Sender: TObject);
begin
  StretchCB.Enabled := (RadioGroup.ItemIndex = 1);
end;

end.
