unit JmpJackU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, MMSystem;

{$R JJRES.RES}

const
  IDS_UP = 101;
  IDS_DOWN = 102;

type
  TMainForm = class(TForm)
    Image: TImage;
    Label1: TLabel;
    Start: TButton;
    Stop: TButton;
    procedure FormCreate(Sender: TObject);
    procedure StartClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
  private
    { Deklaracje prywatne }
    Done : Boolean;
    procedure DrawImage(var Name: string);
  public
    { Deklaracje publiczne }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Image.Picture.Bitmap.
    LoadFromResourceName(HInstance, 'ID_BITMAP1');
end;

procedure TMainForm.StartClick(Sender: TObject);
var
  S       : string;
  ResName : string;
  I       : Integer;
  Buff    : array [0..9] of Char;
begin

  { Po klikniciu na przycisku Start, animacja       }
  { rozpoczyna swoj prac. Nazwy zasobw bitmap    }
  { nosz nazwy od ID_BITMAP1 do ID_BITMAP5          }
  { dlatego na pocztku zaczniemy od acucha        }
  { 'ID_BITMAP' do ktrego, w miar potrzeby         }
  { dodawane bd kolejne cyfry.                     }
  S := 'ID_BITMAP';
  { Znacznik informujcy o zakoczeniu animacji. }
  Done := False;

  { Rozpoczcie ptli i kontynuowanie jej 	}
  { a do momentu nacinicia przycisku 'Stop'.	}

  while not Done do begin
    { Ptla wykonywana kolejno dla wszystkich nazw bitmap }
    { od 1 do 5.}
    for I := 1 to 5 do begin
      { Doczenie wartoci "I" do koca acucha,	}
      { aby skonstruowa acuch bdcy nazw zasobu 	}
      ResName := S + IntToStr(I);
      { Wywoanie metody klasy w celu	}
      { wywietlenia bitmapy			}
      DrawImage(ResName);
    end;
    { Zaadowanie zasobu acucha o wartoci 'Up' za pomoc 	}
    { funkcji WinAPI - LoadString, wywietlenie acucha		}
    { i przekazanie systemowi Windows polecenia ponownego 
    { narysowania etykiety.                                      }
    LoadString(HInstance, IDS_UP, Buff, SizeOf(Buff));
    Label1.Caption := Buff;
    Label1.Refresh;
    { Odtworzenie dwiku 'up' przy uyciu funkcji Windows API 	}
    { PlaySound. Asynchroniczne odtworzenie dwiku.		}
    PlaySound('ID_WAVEUP',
      HInstance, SND_ASYNC or SND_RESOURCE);
    { Zatrzymanie animacji na chwil w momencie wyskoku. }
    Sleep(200);
    { Powtrzenie caego procesu, ale w odwrotnym kierunku.}
    for I := 5 downto 1 do begin
      ResName := S + IntToStr(I);
      DrawImage(ResName);
    end;
    PlaySound('ID_WAVEDOWN',
      HInstance, SND_ASYNC or SND_RESOURCE);
    LoadString(HInstance, IDS_DOWN, Buff, SizeOf(Buff));
    Label1.Caption := Buff;
    Label1.Refresh;
    Sleep(200);
  end;
end;

procedure TMainForm.StopClick(Sender: TObject);
begin
  { Nacinito przycisk Stop, przekazanie polecenia }
  { zakoczenia ptli. }
  Done := True;
end;

procedure TMainForm.DrawImage(var Name : string);
begin
  { Zaadowanie bitmapy na podstawie }
  { nazwy przekazanej w nagwku }
  Image.Picture.Bitmap.
    LoadFromResourceName(HInstance, name);
  { Pchnicie ptli komunikatw, aby Windows }
  { mia szans wywietli bitmap.			}
   Application.ProcessMessages;

  { Chwilowe upienie procesu, aby animacja }
  { nie odtwarzaa si zbyt szybko. }
  Sleep(20);
end;

end.


