unit BTMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    Panel2: TPanel;
    BtnsSpeedBtn: TSpeedButton;
    BitBtnsSpeedBtn: TSpeedButton;
    DrawMode: TSpeedButton;
    PaintMode: TSpeedButton;
    EraseMode: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    ModeLabel: TLabel;
    Bevel1: TBevel;
    ShowButtons: TButton;
    ShowBitBtns: TBitBtn;
    Panel1: TPanel;
    ResultLabel: TLabel;
    AllowAllUpBox: TCheckBox;
    procedure ShowButtonsClick(Sender: TObject);
    procedure AllowAllUpBoxClick(Sender: TObject);
    procedure DrawModeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses Button, BitBtn;

{$R *.DFM}

procedure TMainForm.ShowButtonsClick(Sender: TObject);
var
  Res : Integer;
  Text : string;
begin
  if (Sender = ShowButtons) or (Sender = BtnsSpeedBtn) then
    Res := ButtonForm.ShowModal
  else
    Res := BitBtnForm.ShowModal;
  case Res of
    mrOk     : Text := 'OK';
    mrCancel : Text := 'Cancel';
    mrAbort  : Text := 'Abort';
    mrRetry  : Text := 'Retry';
    mrIgnore : Text := 'Ignore';
    mrYes    : Text := 'Yes';
    mrNo     : Text := 'No';
    mrAll    : Text := 'All';
  else
    Text := 'custom';
  end;
  ResultLabel.Caption :=
    'Klikne w przycisk "' + Text + '".';
end;

procedure TMainForm.AllowAllUpBoxClick(Sender: TObject);
begin
  DrawMode.AllowAllUp := AllowAllUpBox.Checked;
end;

procedure TMainForm.DrawModeClick(Sender: TObject);
var
  S : string;
begin
  S := 'Tryb: ';
  with Sender as TSpeedButton do
    S := S + Hint;
  if not DrawMode.Down and not PaintMode.Down and not EraseMode.Down then
    S := 'Tryb: None';
  ModeLabel.Caption := S;
end;

end.
