unit SamolotU;

interface

uses
  SysUtils;

const
  {Typy samolotw}
  Odrzutowy      = 0;
  Turbosmiglowy  = 1;
  Awionetka      = 2;

  {Stany, w jakich moe sie znajdowa samolot}
  StStart        = 0;
  StPrzelot      = 1;
  StLadowanie    = 2;
  StNaPasie      = 3;

  {Typy komunikatw}
  PolZmien       = 0;
  PolStartuj     = 1;
  PolLaduj       = 2;
  PolRaportuj    = 3;

type
   TSamolot = class
   private
     Nazwa       : string;
     Predkosc    : Integer;
     Wysokosc    : Integer;
     Kierunek    : Integer;
     Stan        : Integer;
     Rodzaj      : Integer;
     Pulap       : Integer;
   protected
     procedure Startuj(Kier : Integer); virtual;
     procedure Laduj; virtual;
   public
     constructor Create(Naz : string; Rodz : Integer = Odrzutowy);
     function WyslijPolecenie(Pol : Integer; var Odpowiedz : string;
        Pred : Integer; Kier : Integer; Wys : Integer) : Boolean;
     function JakiStan(var StanString : string) : Integer; overload; virtual;
     function JakiStan : Integer; overload;
     function JakaPredkosc : Integer;
     function JakiKierunek : Integer;
     function JakaWysokosc : Integer;
     function JakaNazwa : string;
   end;

implementation

constructor TSamolot.Create(Naz : string; Rodz : Integer);
begin
  inherited Create;
  Nazwa := Naz;
  Rodzaj := Rodz;
  Stan := StNaPasie;
  case Rodzaj of
    Odrzutowy : Pulap := 35000;
    Turbosmiglowy : Pulap := 25000;
    Awionetka : Pulap := 8000;
  end;
end;

procedure TSamolot.Startuj(Kier : Integer);
begin
  Kierunek := Kier;
  Stan := StStart;
end;

procedure TSamolot.Laduj;
begin
  Predkosc := 0;
  Kierunek := 0;
  Wysokosc := 0;
  Stan := StNaPasie;
end;

function TSamolot.WyslijPolecenie(Pol : Integer; var Odpowiedz : string;
        Pred : Integer; Kier : Integer; Wys : Integer) : Boolean;
begin
  Result := True;

  {Podjcie odpowiedniej akcji w zalenoci od otrzymanego polecenia}
  case Pol of
    PolStartuj :
      {Nie mona wystartowa bdc ju w powietrzu}
      if Stan <> StNaPasie then begin
        Odpowiedz := Nazwa + ': Jestem ju w powietrzu!';
        Result := False;
      end else
        Startuj(Kier);
    PolZmien :
      begin
        {Sprawdzenie, czy polecenie jest poprawne}
        if Pred > 500 then
          Odpowiedz := 'Bdne polecenie: Prdko nie moe przekracza 500.';
        if Kier > 360 then
          Odpowiedz := 'Bdne polecenie: Kierunek nie moe przekracza 360.';
        if Wys < 100 then
          Odpowiedz := Nazwa + ': Rozbibym si!';
        if Wys > Pulap then
          Odpowiedz := Nazwa + ': Nie mog lecie tak wysoko.';
        if (Pred = 0) and (Kier = 0) and (Wys = 0) then
          Odpowiedz := Nazwa + ': H?';
        if Odpowiedz <> '' then begin
          Result := False;
          Exit;
        end;

        {Nie mona zmieni stanu bdc na ziemi}
        if Stan = StNaPasie then begin
          Odpowiedz := Nazwa + ': Jestem na pasie startowym.';
          Result := False;
        end else begin
          Predkosc := Pred;
          Kierunek := Kier;
          Wysokosc := Wys;
          Stan := StPrzelot;
        end;
      end;
    PolLaduj :
      {Nie mona wyldowa bdc na ziemi}
      if Stan = StNaPasie then begin
        Odpowiedz := Nazwa + ': Jestem na pasie startowym.';
        Result := False;
      end else
        Laduj;
    PolRaportuj :
      begin
        JakiStan(Odpowiedz);
        Exit;
      end;
  end;

  {Jeeli wszystko poszo dobrze}
  if Result then
    Odpowiedz := Nazwa + ': Roger.';
end;

function TSamolot.JakiStan(var StanString : string) : Integer;
begin
  StanString := Format('%s, Wysokosc: %d, Kierunek: %d, ' +
    'Predkosc: %d', [Nazwa, Wysokosc, Kierunek, Predkosc]);
  Result := Stan;
end;

function TSamolot.JakiStan : Integer;
begin
  Result := Stan;
end;

function TSamolot.JakaPredkosc : Integer;
begin
  Result := Predkosc;
end;

function TSamolot.JakiKierunek : Integer;
begin
  Result := Kierunek;
end;

function TSamolot.JakaWysokosc : Integer;
begin
  Result := Wysokosc;
end;

function TSamolot.JakaNazwa : string;
begin
  Result := Nazwa;
end;

end.

