unit RectU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
type
{ A simple rectangle class. }
MyRect = class
private
  Left : Integer;
  Top : Integer;
  Right : Integer;
  Bottom : Integer;
  Text : PChar;
public
  function GetWidth : Integer;
  function GetHeight : Integer;
  procedure SetRect(ALeft, ATop, ARight, ABottom : Integer);
  constructor Create;
  constructor CreateVal(ALeft, ATop, ARight, ABottom : Integer);
  destructor Destroy; override;
end;


constructor MyRect.Create;
begin
  { wywoanie konstruktora odziedziczonego z klasy bazowej }
  inherited Create;
  { przypisz wartoc pocztkow 0 wszystkim polom; nie jest to }
  { bezwzgldnie konieczne, bowiem wszystkie pola i tak s     }
  { zerowane przez konstruktor odziedziczony }
  Left   := 0;
  Top    := 0;
  Right  := 0;
  Bottom := 0;
  { przydzielenie pamici dla pola tekstowego; pole to nie jest }
  { obecnie wykorzystywane, stanowi jednak dobr okazj do }
  { ilustracji przydziau i zwalniania pamici             }
  GetMem(Text, 1024);
end;


constructor MyRect.CreateVal(ALeft, ATop, ARight, ABottom : Integer);
begin
  { wywoanie konstruktora odziedziczonego z klasy bazowej }
  inherited Create;
  { zainicjowanie pl obiektu podanymi wartociami }
  Left   := ALeft;
  Top    := ATop;
  Right  := ARight;
  Bottom := ABottom;
  { przydzielenie pamici dla pola tekstowego }
  GetMem(Text, 1024);
end;


destructor MyRect.Destroy;
begin
  { zwolnienie przydzielonej pamici }
  FreeMem(Text);
  { wywoanie destruktora odziedziczonego z klasy bazowej }
  inherited Destroy;
end;

{ funkcja zwraca szeroko prostokta }
function MyRect.GetWidth : Integer;
begin
  Result := Right - Left;
end;

{ funkcja zwraca wysoko prostokta }
function MyRect.GetHeight : Integer;
begin
  Result := Bottom - Top;
end;

{ zmiana wsprzdnych prostokta }
procedure MyRect.SetRect(ALeft, ATop, ARight, ABottom : Integer);
begin
  Left := ALeft;
  Top  := ATop;
  Right := ARight;
  Bottom := ABottom;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  { deklaracje dwh wskanikw do MyRect }
  Rect1 : MyRect;
  Rect2 : MyRect;
begin
  { utwrz obiekt MyRect za pomoc konstruktora Create }
  Rect1 := MyRect.Create;

  { ustal wsprzdne prostokta }
  Rect1.SetRect(50, 50, 250, 250);

  { utwrz obiekt MyRect za pomoc konstruktora CreateVal }
  { konstruktor ten przypisuje wartoci wsprzdnym prostokta }
  Rect2 := MyRect.CreateVal(0, 0, 100, 100);

  { wywietl wsprzdne prostokta }
  Label1.Caption := 'Szeroko Rect1 : ' + IntToStr(Rect1.GetWidth);
  Label2.Caption := ' Wysoko Rect1 : ' + IntToStr(Rect1.GetHeight);
  Label3.Caption := 'Szeroko Rect2 : ' + IntToStr(Rect2.GetWidth);
  Label4.Caption := ' Wysoko Rect2 : ' + IntToStr(Rect2.GetHeight);

  { zwolnij pami przydzielon dla obydwu obiektw }
  { zaniedbanie tej czynnoci spowoduje wyciek pamici }

  Rect1.Free;
  Rect2.Free;
end;

end.
