unit AirportU;


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Samolotu;

type
  TMainForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    SpeedEdit: TEdit;
    Label2: TLabel;
    AltEdit: TEdit;
    Label3: TLabel;
    HeadingEdit: TEdit;
    CommandGroup: TRadioGroup;
    Button1: TButton;
    ComboBox: TComboBox;
    Label4: TLabel;
    Memo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedEditChange(Sender: TObject);
  private
    Samoloty : array[0..2] of TSamolot;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  I : Integer;
begin
  Samoloty[0] := TSamolot.Create('TWA 599');
  Samoloty[1] := TSamolot.Create('United Express 1022', Turbosmiglowy);
  Samoloty[2] := TSamolot.Create('Cessna 3238T', Awionetka);
  for I := 0 to 2 do
    ComboBox.Items.Add(Samoloty[I].JakaNazwa);
  ComboBox.ItemIndex := 0;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  NrSamolotu   : Integer;
  Komenda      : Integer;
  Odpowiedz    : string;
  NowaPredkosc : Integer;
  NowyKierunek : Integer;
  NowaWysokosc : Integer;
begin
  NrSamolotu := ComboBox.ItemIndex;
  Komenda := 0;
  case CommandGroup.ItemIndex of
    0 : Komenda := PolStartuj;
    1 : Komenda := PolLaduj;
    2 : Komenda := PolZmien;
    3 : Komenda := PolRaportuj;
  end;
  NowaPredkosc    := StrToIntDef(SpeedEdit.Text, 0);
  NowyKierunek    := StrToIntDef(HeadingEdit.Text, 0);
  NowaWysokosc    := StrToIntDef(AltEdit.Text, 0);
  Samoloty[NrSamolotu].WyslijPolecenie(Komenda,
    Odpowiedz, NowaPredkosc, NowyKierunek, NowaWysokosc);
  Memo.Lines.Add(Odpowiedz);
end;

procedure TMainForm.SpeedEditChange(Sender: TObject);
begin
  CommandGroup.ItemIndex := 2;
end;

end.

