unit Install;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    BtnContinue: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    BtnAbort: TButton;
    procedure BtnAbortClick(Sender: TObject);
    procedure BtnContinueClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
 MySubKey: PChar;
 RetCode: Longint;

procedure TForm1.BtnAbortClick(Sender: TObject);
begin
 Application.Terminate;
end;

procedure TForm1.BtnContinueClick(Sender: TObject);
var
 { wolny obszar dysku }
 DskSpc: Longint;
 { Wymagana minimalna ilo miejsca }
 MinDSpace: Longint;
 { Zmienne plikowe wykorzystane przy kopiowaniu }
 InFile, OutFile: File;
 { Zmienne zliczajce skopiowane bloki }
 NumRecsRead, NumRecsWritten: Integer;
 { Bufor kopiowania }
 Buf: array[1..4096] of Byte;
 Result: HKey;
begin
  { Sprawdzamy wolne miejsce na dysku C: }
  MinDSpace := 1024000; { wymagamy co najmiej 1MB }
  DskSpc := DiskFree(3); { wolne miejsce na dysku C: }
  if DskSpc < MinDSpace then
  begin
   ShowMessage('Not enough Diskspace, setup aborting');
   Application.Terminate;
  end;

  { Tworzymy katalog }
  MkDir('C:\MYAPP');

  { ------- Kopiowanie pliku - Pocztek ----- }
   AssignFile(InFile, 'A:\MYAPP.EXE');
   AssignFile(OutFile, 'C:\MYAPP\MYAPP.EXE');
   Reset(InFile,1);
   Rewrite(OutFile,1);
   while not Eof(InFile) do
   begin
    BlockRead(InFile, Buf, SizeOf(Buf), NumRecsRead);
    BlockWrite(OutFile, Buf, NumRecsRead);
   end;
   CloseFile(InFile);
   CloseFile(OutFile);
  { ------- Kopiowanie pliku - Koniec ----- }

  { Wpis do rejestru }
  MySubKey := 'SOFTWARE\MyCompany\MyApp\1.0';
  RetCode := RegCreateKey(HKEY_LOCAL_MACHINE, MySubKey, Result);
  if RetCode = ERROR_SUCCESS then
    RegCloseKey(Result)
  else
    begin
      ShowMessage('Registery Update Failed!');
      Application.Terminate;
    end;

  ShowMessage('Installation Complete');
  Application.Terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
 F: File;
begin
 { Jeli program uruchomimy z parametrem /U,
   przystpujemy do deinstalacji }
 if (ParamCount > 0) and (ParamStr(1) = '/U') then
 begin
  AssignFile(F, 'C:\MYAPP\MYAPP.EXE');
  Erase(F);
  RmDir('C:\MYAPP');
  MySubKey := 'SOFTWARE\MyCompany';
  RetCode := RegDeleteKey(HKEY_LOCAL_MACHINE, MySubKey);
  if RetCode = ERROR_SUCCESS then
  begin
   ShowMessage('MYAPP Successfully Uninstalled');
   Application.Terminate;
  end;
 end;
end;

end.
