unit Tbc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TButClock = class(TButton)
  private
    { Private declarations }
    MainTimer: TTimer;
    procedure LoopTime(Sender: TObject);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TButClock]);
end;

constructor TButClock.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 MainTimer := TTimer.Create(AOwner);
 MainTimer.Interval := 1000;
 MainTimer.OnTimer := LoopTime;
 MainTimer.Enabled := True;
end;

destructor TButClock.Destroy;
begin
 MainTimer.Destroy;
 inherited Destroy;
end;

procedure TButClock.LoopTime(Sender: TObject);
begin
 Caption := TimeToStr(Now);
end;

end.
