unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ShowTriangles: TButton;
    procedure ShowTrianglesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure Triangle(Iteration: Integer);
begin
 Form1.Canvas.Brush.Color := clBlue;
 Form1.Canvas.Polygon([Point(Trunc((Iteration/9)*Form1.Width), 50),
                       Point(Trunc((Iteration/8)*Form1.Width), 100),
                       Point(Trunc(((Iteration-1)/8)*Form1.Width), 100),
                       Point(Trunc((Iteration/9)*Form1.Width), 50)]);
end;

procedure TForm1.ShowTrianglesClick(Sender: TObject);
begin
 Form1.Canvas.Brush.Style := bsSolid;
 Triangle(1);
 Form1.Canvas.Brush.Style := bsClear;
 Triangle(2);
 Form1.Canvas.Brush.Style := bsHorizontal;
 Triangle(3);
 Form1.Canvas.Brush.Style := bsVertical;
 Triangle(4);
 Form1.Canvas.Brush.Style := bsFDiagonal;
 Triangle(5);
 Form1.Canvas.Brush.Style := bsBDiagonal;
 Triangle(6);
 Form1.Canvas.Brush.Style := bsCross;
 Triangle(7);
 Form1.Canvas.Brush.Style := bsDiagCross;
 Triangle(8);


end;

end.
 