unit Addr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Previous: TButton;
    Save: TButton;
    Next: TButton;
    New: TButton;
    Close: TButton;
    procedure FormCreate(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure PreviousClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure SaveClick(Sender: TObject);
    procedure CloseClick(Sender: TObject);
  private
    { Private declarations }
    procedure LoadRecord;
    procedure SaveRecord;
    procedure ShowRecord;
    procedure ClearData;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type

 Address = record
  LastName: String[20];
  FirstName: String[20];
  Phone: String[15];
  StreetAddress: String[50];
  City: String[40];
  State: String[2];
  ZipCode: String[10];
 end;

var

 AddressFile: File of Address;
 AddressData: Address;
 Fname: String;
 RecSize, CurRec: Longint;

procedure TForm1.LoadRecord;
begin
 Read(AddressFile, AddressData);  { odczytujemy rekord z pliku }
 ShowRecord;                      { wyswietlamy rekord na ekranie }
end;

procedure TForm1.SaveRecord;
begin
 { pobieramy wprowadzone przez uytkownika dane }
 AddressData.LastName := Edit1.Text;
 AddressData.FirstName := Edit2.Text;
 AddressData.Phone := Edit3.Text;
 AddressData.StreetAddress := Edit4.Text;
 AddressData.City := Edit5.Text;
 AddressData.State := Edit6.Text;
 AddressData.ZipCode := Edit7.Text;
 { zapisujemy rekord na dysk }
 Write(AddressFile, AddressData);
end;

procedure TForm1.ShowRecord;
begin
 Edit1.Text := AddressData.LastName;
 Edit2.Text := AddressData.FirstName;
 Edit3.Text := AddressData.Phone;
 Edit4.Text := AddressData.StreetAddress;
 Edit5.Text := AddressData.City;
 Edit6.Text := AddressData.State;
 Edit7.Text := AddressData.ZipCode;
end;

procedure TForm1.ClearData;
begin
 Edit1.Text := '';
 Edit2.Text := '';
 Edit3.Text := '';
 Edit4.Text := '';
 Edit5.Text := '';
 Edit6.Text := '';
 Edit7.Text := '';
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
 ClearData;                      { Czycimy pola edycji }
 CurRec := 0;                    { Biecy rekord = 0 }
 Fname := 'ADDRESS.DAT';         { nazwa plik danych }
 AssignFile(AddressFile, Fname); { ustawiamy zmienna plikow }
 RecSize := SizeOf(AddressData); { obliczamy rozmiar rekordu }
 if FileExists(Fname) then { jeli jest plik, otwieramy go... }
  begin
   Reset(AddressFile);
    if not Eof(AddressFile) then
    begin
     Read(AddressFile, AddressData);
     ShowRecord;
    end;
  end
 else                      { ...jeli nie ma, tworzymy }
  begin
   ClearData;
   Rewrite(AddressFile);
  end;
end;

procedure TForm1.NewClick(Sender: TObject);
begin
 repeat
  CurRec := CurRec + 1;
  Seek(AddressFile, CurRec);
 until Eof(AddressFile);
 ClearData;                 { czycimy pola edycji }
 SaveRecord;                { dodajemy nowy rekord }
 Seek(AddressFile, CurRec); { ustawiamy si na dodanym rekordzie }
end;

procedure TForm1.PreviousClick(Sender: TObject);
begin
 if CurRec-1 < 0 then { prba przejcia przed pierwszy rekord }
  begin
   CurRec := 0;
   Seek(AddressFile, CurRec);
   ShowMessage('Pocztek pliku');
  end
 else
  begin
   CurRec := CurRec - 1;
   Seek(AddressFile, CurRec);
   Read(AddressFile, AddressData);
   Seek(AddressFile, CurRec);
   ShowRecord;
  end;
end;

procedure TForm1.NextClick(Sender: TObject);
begin
 CurRec := CurRec + 1;
 Seek(AddressFile, CurRec);
 if not Eof(AddressFile) then  { nie osignito koca pliku... }
  begin
   Read(AddressFile, AddressData);
   Seek(AddressFile, CurRec);
   ShowRecord;
  end
 else                          { ...koniec pliku }
  begin
   CurRec := CurRec - 1;
   Seek(AddressFile, CurRec);
   ShowMessage('Koniec pliku');
  end;
end;



procedure TForm1.SaveClick(Sender: TObject);
begin
 SaveRecord;
 ShowRecord;
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
 SaveRecord;
 CloseFile(AddressFile);
 Application.Terminate;
end;

end.
