unit Addition;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Mask, Grids;

type
  TAdditionalTab = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Bevel1: TBevel;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Shape1: TShape;
    Image1: TImage;
    Label1: TLabel;
    MaskEdit1: TMaskEdit;
    StringGrid1: TStringGrid;
    Button1: TButton;
    ScrollBox1: TScrollBox;
    BitBtn4: TBitBtn;
    Panel2: TPanel;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AdditionalTab: TAdditionalTab;

implementation
uses Standard;

{$R *.DFM}

procedure TAdditionalTab.BitBtn1Click(Sender: TObject);
begin
 StandardTab.Show;
 AdditionalTab.Hide;
end;

procedure TAdditionalTab.BitBtn3Click(Sender: TObject);
begin
 AdditionalTab.Close;
end;

procedure TAdditionalTab.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Application.Terminate;
end;

procedure TAdditionalTab.SpeedButton1Click(Sender: TObject);
begin
 if SpeedButton1.Down = True then
 begin
  Image1.Visible := False;
  Shape1.Brush.Color := clRed;
 end;
end;

procedure TAdditionalTab.SpeedButton2Click(Sender: TObject);
begin
 if SpeedButton2.Down = True then
 begin
  Image1.Visible := True;
  Shape1.Brush.Color := clLime;
 end;
end;

procedure TAdditionalTab.Button1Click(Sender: TObject);
var
 x, y: Integer;
begin
 with StringGrid1 do
  for x := 0 to ColCount-1 do
   for y := 0 to RowCount-1 do
    Cells[x,y] := 'Cord. ' + IntToStr(x) + ' - ' + IntToStr(y);
end;

procedure TAdditionalTab.BitBtn4Click(Sender: TObject);
begin
 ShowMessage('Testing Help Button in ScrollBox!');
end;

end.
