unit Project1Lib;

{ Project1Lib Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Project1Lib: TGUID = '{2CC258E0-0046-11D1-81CC-E82602C10627}';

const

{ TxDragMode }

  dmManual = 0;
  dmAutomatic = 1;

{ TxMouseButton }

  mbLeft = 0;
  mbRight = 1;
  mbMiddle = 2;

const

{ Component class GUIDs }
  Class_ActXClockX: TGUID = '{2CC258E3-0046-11D1-81CC-E82602C10627}';

type

{ Forward declarations }
  IActXClockX = interface;
  DActXClockX = dispinterface;
  IActXClockXEvents = dispinterface;

  TxDragMode = TOleEnum;
  TxMouseButton = TOleEnum;

{ Dispatch interface for ActXClockX Control }

  IActXClockX = interface(IDispatch)
    ['{2CC258E1-0046-11D1-81CC-E82602C10627}']
    procedure Click; safecall;
    function Get_Cancel: WordBool; safecall;
    procedure Set_Cancel(Value: WordBool); safecall;
    function Get_Caption: WideString; safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    function Get_Default: WordBool; safecall;
    procedure Set_Default(Value: WordBool); safecall;
    function Get_DragCursor: Smallint; safecall;
    procedure Set_DragCursor(Value: Smallint); safecall;
    function Get_DragMode: TxDragMode; safecall;
    procedure Set_DragMode(Value: TxDragMode); safecall;
    function Get_Enabled: WordBool; safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    function Get_Font: Font; safecall;
    procedure Set_Font(const Value: Font); safecall;
    function Get_ModalResult: Integer; safecall;
    procedure Set_ModalResult(Value: Integer); safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Cursor: Smallint; safecall;
    procedure Set_Cursor(Value: Smallint); safecall;
    procedure MakeBold; safecall;
    property Cancel: WordBool read Get_Cancel write Set_Cancel;
    property Caption: WideString read Get_Caption write Set_Caption;
    property Default: WordBool read Get_Default write Set_Default;
    property DragCursor: Smallint read Get_DragCursor write Set_DragCursor;
    property DragMode: TxDragMode read Get_DragMode write Set_DragMode;
    property Enabled: WordBool read Get_Enabled write Set_Enabled;
    property Font: Font read Get_Font write Set_Font;
    property ModalResult: Integer read Get_ModalResult write Set_ModalResult;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property Cursor: Smallint read Get_Cursor write Set_Cursor;
  end;

{ DispInterface declaration for Dual Interface IActXClockX }

  DActXClockX = dispinterface
    ['{2CC258E1-0046-11D1-81CC-E82602C10627}']
    procedure Click; dispid 1;
    property Cancel: WordBool dispid 2;
    property Caption: WideString dispid 3;
    property Default: WordBool dispid 4;
    property DragCursor: Smallint dispid 5;
    property DragMode: TxDragMode dispid 6;
    property Enabled: WordBool dispid 7;
    property Font: Font dispid 8;
    property ModalResult: Integer dispid 9;
    property Visible: WordBool dispid 10;
    property Cursor: Smallint dispid 11;
    procedure MakeBold; dispid 12;
  end;

{ Events interface for ActXClockX Control }

  IActXClockXEvents = dispinterface
    ['{2CC258E2-0046-11D1-81CC-E82602C10627}']
    procedure OnClick; dispid 1;
    procedure OnKeyPress(var Key: Smallint); dispid 2;
  end;

{ ActXClockXControl }

  TActXClockXOnKeyPress = procedure(Sender: TObject; var Key: Smallint) of object;

  TActXClockX = class(TOleControl)
  private
    FOnClick: TNotifyEvent;
    FOnKeyPress: TActXClockXOnKeyPress;
    FIntf: IActXClockX;
  protected
    procedure InitControlData; override;
    procedure InitControlInterface(const Obj: IUnknown); override;
  public
    procedure Click;
    procedure MakeBold;
    property ControlInterface: IActXClockX read FIntf;
  published
    property Cancel: WordBool index 2 read GetWordBoolProp write SetWordBoolProp stored False;
    property Caption: WideString index 3 read GetWideStringProp write SetWideStringProp stored False;
    property Default: WordBool index 4 read GetWordBoolProp write SetWordBoolProp stored False;
    property DragCursor: Smallint index 5 read GetSmallintProp write SetSmallintProp stored False;
    property DragMode: TxDragMode index 6 read GetTOleEnumProp write SetTOleEnumProp stored False;
    property Enabled: WordBool index 7 read GetWordBoolProp write SetWordBoolProp stored False;
    property Font: TFont index 8 read GetTFontProp write SetTFontProp stored False;
    property ModalResult: Integer index 9 read GetIntegerProp write SetIntegerProp stored False;
    property Visible: WordBool index 10 read GetWordBoolProp write SetWordBoolProp stored False;
    property Cursor: Smallint index 11 read GetSmallintProp write SetSmallintProp stored False;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property OnKeyPress: TActXClockXOnKeyPress read FOnKeyPress write FOnKeyPress;
  end;

procedure Register;

implementation

uses ComObj;

procedure TActXClockX.InitControlData;
const
  CEventDispIDs: array[0..1] of Integer = (
    $00000001, $00000002);
  CFontIDs: array [0..0] of Integer = (
    $00000008);
  CControlData: TControlData = (
    ClassID: '{2CC258E3-0046-11D1-81CC-E82602C10627}';
    EventIID: '{2CC258E2-0046-11D1-81CC-E82602C10627}';
    EventCount: 2;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil;
    Flags: $00000000;
    Version: 300;
    FontCount: 1;
    FontIDs: @CFontIDs);
begin
  ControlData := @CControlData;
end;

procedure TActXClockX.InitControlInterface(const Obj: IUnknown);
begin
  FIntf := Obj as IActXClockX;
end;

procedure TActXClockX.Click;
begin
  ControlInterface.Click;
end;

procedure TActXClockX.MakeBold;
begin
  ControlInterface.MakeBold;
end;


procedure Register;
begin
  RegisterComponents('ActiveX', [TActXClockX]);
  RegisterNonActiveX([TActXClockX]);
end;

end.
