unit Ex1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Menus, MPlayer;

type
  TForm1 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Capture: TButton;
    PaintBox1: TPaintBox;
    Exit1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure CaptureClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PaintBox1Paint(Sender: TObject);
  private
    { Private declarations }
    ImgBitmap: TBitmap;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  MediaPlayer1.FileName := OpenDialog1.FileName;
  MediaPlayer1.Open;
  MediaPlayer1.Display := Form1;
  MediaPlayer1.DisplayRect := Rect(10,10,200,200);
 end;
end;

procedure TForm1.CaptureClick(Sender: TObject);
begin
 { przechwywujemy biec klatk i zapamitujemy j w postaci mapy bitowej }
 ImgBitmap.Canvas.CopyRect(Rect(0,0,200,200), Form1.Canvas, Rect(10,10,210,210));
 PaintBox1.Invalidate;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 Canvas.FrameRect(Rect(8,8,212,212)); { odrysowujemy ramk }
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 Application.Terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 { tworzymy i inicjujemy obiekt mapy bitowej }
 ImgBitmap := TBitmap.Create;
 ImgBitmap.Height := 200;
 ImgBitmap.Width := 200;
 ImgBitmap.Canvas.Rectangle(0,0,200,200);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 { zwalniamy obiekt mapy bitowej }
 ImgBitmap.Free;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
 { wywitlamy biec zawarto mapy bitowej }
 PaintBox1.Canvas.CopyRect(Rect(0,0,200,200),ImgBitmap.Canvas,Rect(0,0,200,200));
end;

end.
