unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus;

type
  TMixup = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Orig: TImage;
    NewImage: TImage;
    MixupBitmap: TBitBtn;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure MixupBitmapClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Mixup: TMixup;

implementation

{$R *.DFM}

procedure TMixup.Exit1Click(Sender: TObject);
begin
 Application.Terminate;
end;

procedure TMixup.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
 begin
  Orig.Picture.LoadFromFile(OpenDialog1.FileName);
 end;
end;

procedure TMixup.Save1Click(Sender: TObject);
begin
 if SaveDialog1.Execute then
 begin
  NewImage.Picture.SaveToFile(SaveDialog1.FileName);
 end;
end;

procedure TMixup.MixupBitmapClick(Sender: TObject);
var
 NewBitmap: TBitmap;
 X, Y, NewX, NewY: Integer;
 ChunkX, ChunkY: Integer;
begin
 NewBitmap := TBitmap.Create;

 NewBitmap.Height := Orig.Picture.Bitmap.Height;
 NewBitmap.Width := Orig.Picture.Bitmap.Width;

 ChunkX := NewBitmap.Width div 4;
 ChunkY := NewBitmap.Height div 4;

 for X := 0 to 3 do
  for Y := 0 to 3 do
   begin
    NewX := Random(3);
    NewY := Random(3);
    NewBitmap.Canvas.CopyRect(
      Rect(X*ChunkX, Y*ChunkY, (X+1)*ChunkX, (Y+1)*ChunkY),
      Orig.Picture.Bitmap.Canvas,
      Rect(NewX*ChunkX, NewY*ChunkY, (NewX+1)*ChunkX, (NewY+1)*ChunkY));
   end;

 NewImage.Picture.Graphic := NewBitmap;

end;

end.
