#
#  Plik:  mnist_nn_experiments_samples.py
#
#  Zmniejszony zestaw MNIST + sieć neuronowa (R6).
#
#  RTK, 15.10.2018
#  Ostatnia aktualizacja:  15.10.2018
#
###############################################################

import numpy as np
import time
from sklearn.neural_network import MLPClassifier 


def run(x_train, y_train, x_test, y_test, clf):
    """Uczenie i testowanie"""

    s = time.time()
    clf.fit(x_train, y_train)
    e = time.time()-s
    loss = clf.loss_
    return [clf.score(x_test, y_test), loss, e]


def nn(epochs):
    """Inicjalizacja sieci"""

    return MLPClassifier(solver="sgd", verbose=False, tol=1e-8,
            nesterovs_momentum=False, early_stopping=False,
            learning_rate_init=0.05, momentum=0.9, max_iter=epochs,
            hidden_layer_sizes=(1000,500), activation="relu",
            learning_rate="constant", batch_size=100)


def main():
    """Przeprowadza eksperymenty na danych wektorowych MNIST"""

    #  Skalowany wektor danych MNIST: [0,1)
    x_train = np.load("../data/mnist/mnist_train_vectors.npy").astype("float64")/256.0
    y_train = np.load("../data/mnist/mnist_train_labels.npy")
    x_test = np.load("../data/mnist/mnist_test_vectors.npy").astype("float64")/256.0
    y_test = np.load("../data/mnist/mnist_test_labels.npy")

    #  Próby zbioru uczącego
    N = [100, 200, 300, 400, 500, 600,
        700, 800, 900, 1000, 1500, 2000, 2500, 3000, 3500, 4000,
        4500, 5000, 7500, 10000, 15000, 20000, 25000, 30000]
    M = 5

    for n in N:
        scores = np.zeros(M)
        print("Próby = %5d" % n)
        for i in range(M):
            idx = np.argsort(np.random.random(y_train.shape[0]))
            x_train = x_train[idx]
            y_train = y_train[idx]
            x = x_train[:n]
            y = y_train[:n]
            epochs = int((100.0/n)*1000) # Liczba epok wymagana do wykonania 1,000 kroków SGD
            s,l,e = run(x, y, x_test, y_test, nn(epochs))
            scores[i] = s
            print("    Ocena = %0.5f, Strata = %0.5f, Epoki = %d, Czas uczenia = %0.3f" % (s,l,epochs,e))
        print("    Średnia ocena = %0.5f +/- %0.5f" % (scores.mean(), scores.std()/np.sqrt(M)))
        print()
    print()


main()

