/*	KSIAZKI		*/

CREATE TABLE KSIAZKI
(
IDKSIAZKI	INTEGER	NOT NULL,
IDAUTORA	INTEGER NOT NULL,
IDAUTORA2	INTEGER,
IDWYDAL		INTEGER NOT NULL,
ROKWYDANIA	D_ROK,
TYTUL		D_LONGC NOT NULL,
TYTUL2		D_LONGC,
CENA		DECIMAL(4,2),
CONSTRAINT KSIAZKI_PK PRIMARY KEY(IDKSIAZKI)
);

ALTER TABLE ksiazki add constraint KSIAZKI_FK_IDWYDAL FOREIGN KEY(idwydal) references WYDAWNICTWA(idwydal)
ON DELETE NO ACTION;

ALTER TABLE ksiazki add constraint KSIAZKI_FK_IDAUTORA FOREIGN KEY(idautora) references AUTORZY(idautora)
ON DELETE NO ACTION;

CREATE GENERATOR G_KSIAZKI;
SET GENERATOR G_KSIAZKI TO -1;

SET TERM ^ ;

CREATE TRIGGER T_KSIAZKI FOR KSIAZKI
ACTIVE BEFORE INSERT
POSITION 0
AS  
BEGIN
   NEW.IDKSIAZKI = GEN_ID(G_KSIAZKI, 1);
END
^

SET TERM ; ^

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
0, 1, 2002, 'Delphi Almanach');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
1, 2, 2000, 'Programowanie w Delphi 5');

insert into KSIAZKI(idautora, idautora2, idwydal, rokwydania, tytul, tytul2) values(
2, 3, 1, 2002, 'Projektowanie zorientowane obiektowo', 'Wzorce projektowe');

insert into KSIAZKI(idautora, idautora2, idwydal, rokwydania, tytul, tytul2) values(
4, 5, 1, 2002, 'Delphi 6', 'Vademecum profesjonalisty');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul, tytul2) values(
6, 1, 2002, 'Delphi 6', 'Praktyka programowania');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul, tytul2) values(
7, 1, 1999, 'Delphi 4', 'Tworezenie systemw bazodanowych');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
8, 1, 1996, 'SQL');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
7, 1, 2001, 'SQL w InterBase dla Windows i Linuksa');


select * from KSIAZKI;
