unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, ActnList, Buttons, DBXpress;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ListView: TListView;
    SpeedButton1: TSpeedButton;
    sbInsert: TSpeedButton;
    sbEdit: TSpeedButton;
    sbDelete: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
    procedure ListViewKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure pokaz_osoby();

    procedure my_insert();
    procedure my_edit();
    procedure my_delete();
    
    constructor Create(AOwner: TComponent); override;
  end;

var
  FOsoby: TFOsoby;

implementation

uses DataModule, DialogOsoba;

{$R *.dfm}

constructor TFOsoby.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
//   ShowMessage('constructor');
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   pokaz_osoby();
end;

procedure TFOsoby.ActionInsertExecute(Sender: TObject);
begin
   my_insert();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFOsoby.ListViewKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_INSERT then begin
      my_insert();
   end;

   if Key = VK_RETURN then begin
      my_edit();
   end;

   if Key = VK_DELETE then begin
      my_delete();
   end;
end;

procedure TFOsoby.pokaz_osoby();
var
   i         : Integer;
   Kolumny   : TListColumn;
   ListItem  : TListItem;

   // pola tebeli osoby
   idosoby   : String;
   nazwisko  : String;
   imie      : String;
   dataur    : String;
   mcowosc   : String;
   ulicainr  : String;
   kodp      : String;
   miasto    : String;
   pesel     : String;

begin
   DM.SQLDataSet.Open();

   with ListView do begin
      Parent            := Self;
      Align             := alClient;
      ViewStyle         := vsReport;
      RowSelect         := True;
      ReadOnly          := True;
      Color             := clInfobk;
      GridLines         := True;
      ShowColumnHeaders := true;
   end;
   
   with ListView do begin
      // kolumna id
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Idosoby';
      // Kolumny.Width   := 20;
      Kolumny.Width   := 0; // aby kolumna bya niewidoczna dla uytkownika

      // nazwisko
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Nazwisko';
      Kolumny.Width   :=  80;

      // imie
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Imi';
      Kolumny.Width   := 70;

      // dataur
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Data ur.';
      Kolumny.Width   := 80;

      // MCOWOSC
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Miejsce ur.';
      Kolumny.Width   := 90;

      // ulicainr
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Ulica i nr';
      Kolumny.Width   := 140;

      // kodp
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Kod p.';
      Kolumny.Width   := 70;

      // miasto
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Miejscowo';
      Kolumny.Width   := 80;

      // pesel
      Kolumny         := Columns.Add;
      Kolumny.Caption := 'Pesel';
      Kolumny.Width   := 100;
   end;

   with ListView do begin
      while not DM.SQLDataSet.EOF do begin
         idosoby    := DM.SQLDataSet.FieldByName('IDOSOBY').AsString;
         nazwisko   := DM.SQLDataSet.FieldByName('NAZWISKO').AsString;
         imie       := DM.SQLDataSet.FieldByName('IMIE').AsString;
         dataur     := DM.SQLDataSet.FieldByName('DATAUR').AsString;
         mcowosc    := DM.SQLDataSet.FieldByName('MCOWOSC').AsString;
         ulicainr   := DM.SQLDataSet.FieldByName('ULICAINR').AsString;
         kodp       := DM.SQLDataSet.FieldByName('KODP').AsString;
         miasto     := DM.SQLDataSet.FieldByName('MIASTO').AsString;
         pesel      := DM.SQLDataSet.FieldByName('PESEL').AsString;

         ListItem := items.Add;

         // uwaga: do pierwszej kolumny mozna si odwoa przez Caption
         ListItem.Caption := idosoby;

         // Nastpne kolumny uzyskujemy poprzez SubItems[0,1,2,...]
         ListItem.SubItems.Add(nazwisko);
         ListItem.SubItems.Add(imie);
         ListItem.SubItems.Add(dataur);
         ListItem.SubItems.Add(mcowosc);
         ListItem.SubItems.Add(ulicainr);
         ListItem.SubItems.Add(kodp);
         ListItem.SubItems.Add(miasto);
         ListItem.SubItems.Add(pesel);

         DM.SQLDataSet.Next();
      end;
   end;

   DM.SQLDataSet.Close();
end;

procedure TFOsoby.my_edit();
var
   Res  : TModalResult;  // bada w jaki sposb zostao zamkniete okno dialogowe
   ilel : Integer;       // ilo elementw w ListView

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := ListView.Items.Count;
   if ilel = 0 then begin
      EXIT;
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self, True, ListView);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         ListView.Visible := False;

         // ListView.Items.Clear();
         ListView.Columns.Clear();
         ListView.Clear();

         pokaz_osoby();

         ListView.Visible := True;
      end;
   finally
      FreeAndNil(DlgOsoba);
      ListView.SetFocus();      
   end;
end;

procedure TFOsoby.my_insert();
var
   Res : TModalResult;

begin
   try
      DlgOsoba := TDlgOsoba.Create(Self, False, ListView);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then begin
         ListView.Visible := False;

         // ListView.Items.Clear();
         ListView.Columns.Clear();
         ListView.Clear();

         pokaz_osoby();

         ListView.Visible := True;
      end;
   finally
      FreeAndNil(DlgOsoba);
      ListView.SetFocus();
   end;
end;

procedure TFOsoby.my_delete();
var
   TD      : TTransactionDesc;
   ilel    : integer;
   poz     : integer;
   idosoby : Integer;

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := ListView.Items.Count;
   if ilel = 0 then begin
      EXIT;
   end;

   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      idosoby := StrToInt(ListView.Selected.Caption);

      try
         try
            if not DM.SQLConnection.InTransaction then begin
               TD.TransactionID  := 1;
               TD.IsolationLevel := xilREADCOMMITTED;

               DM.SQLConnection.StartTransaction(TD);
               DM.SQLDataSetDelete.ParamByName('IDOSOBY').AsInteger := idosoby;
               DM.SQLDataSetDelete.ExecSQL();
               DM.SQLConnection.Commit(TD);

               ListView.Visible := False;
               ListView.Columns.Clear();
               ListView.Clear();
               pokaz_osoby();
               ListView.Visible := True;

               ModalResult := mrOK;
            end
            else begin
               ShowMessage('InTransaction');
            end;
         except
            DM.SQLConnection.Rollback(TD);
            ShowMessage('Rollback');
         end;
      finally
         DM.SQLDataSetDelete.Close();
         ListView.SetFocus();
      end;
   end
end;

end.

   

