unit BOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, ComCtrls, Buttons, ExtCtrls, Grids, DBGrids, DataModule;

type
  TFOsoby = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    StatusBar1: TStatusBar;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionEdit: TAction;
    DBGrid1: TDBGrid;
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ActionEditExecute(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure my_edit();
  end;

var
  FOsoby: TFOsoby;

implementation

uses DB, IBQuery, DOsoba;

{$R *.dfm}

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := Nil;
end;

procedure TFOsoby.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_RETURN then begin
      my_edit();
   end;
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.DBGrid1DblClick(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_RETURN then begin
      my_edit();
   end;
end;

procedure TFOsoby.my_edit();
var
   Res      : TModalResult;
   zakladka : TBookMark;

begin
   if DM.TableOsoby.RecordCount = 0 then begin
      EXIT;
   end;

   zakladka := DM.TableOsoby.GetBookmark();

   DlgOsoba := TDlgOsoba.Create(Self, true);

   try
      Res := DlgOsoba.ShowModal();
   finally
      // DM.TableOsoby.Close();
      // DM.TableOsoby.Open();
      DM.TableOsoby.GotoBookmark(zakladka);
      DM.TableOsoby.FreeBookMark(zakladka);
   end;
end;

end.

