unit RemoteDataModule;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, AplSerwer_TLB, StdVcl, DBXpress, FMTBcd, DB, Provider, SqlExpr;

type
  TRDM = class(TRemoteDataModule, IMyAppSerwer)
    SQLConnection: TSQLConnection;
    SQLDataSet: TSQLDataSet;
    DataSetProvider: TDataSetProvider;
    SQLDataSetIDOSOBY: TIntegerField;
    SQLDataSetNAZWISKO: TStringField;
    SQLDataSetIMIE: TStringField;
    SQLDataSetDATAUR: TDateField;
    SQLDataSetMCOWOSC: TStringField;
    SQLDataSetULICAINR: TStringField;
    SQLDataSetKODP: TStringField;
    SQLDataSetMIASTO: TStringField;
    SQLDataSetPESEL: TStringField;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

class procedure TRDM.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  TComponentFactory.Create(ComServer, TRDM,
    Class_RDM, ciMultiInstance, tmApartment);
end.
