unit DialogOsoba;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Mask, Dialogs, DBXPress, variants;

type
  TDlgOsoba = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicainr: TMaskEdit;
    meKodp: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure dtpDataUrChange(Sender: TObject);
    procedure dtpDataUrExit(Sender: TObject);
    procedure meNazwiskoExit(Sender: TObject);
  private
    { Private declarations }
    tryb_update : Boolean;

    // pola tabeli osoby
    lp       : Integer;
    idosoby  : integer;
    nazwisko : String;
    imie     : String;
    dataur   : TDateTime;
    mcowosc  : String;
    ulicainr : String;
    kodp     : String;
    miasto   : String;
    pesel    : String;

  public
    { Public declarations }

    procedure set_tryb(tryb : Boolean);

    // wstawiam wartoci do zmiennych ekranowych (poza idosoby)
    procedure set_idosoby(Value: integer);
    procedure set_nazwisko(Value: String);
    procedure set_imie(Value: String);
    procedure set_dataur(Value: TDateTime);
    procedure set_mcowosc(Value: String);
    procedure set_ulicainr(Value: String);
    procedure set_kodp(Value: String);
    procedure set_miasto(Value: String);
    procedure set_pesel(Value: String);

    // pobieram wartoci ze zmiennyehc ekranowych (poza idosoby)
    function get_idosoby() : Integer;
    function get_nazwisko() : String;
    function get_imie() : String;
    function get_dataur() : TDateTime;
    function get_mcowosc() : String;
    function get_ulicainr() : String;
    function get_kodp() : String;
    function get_miasto() : String;
    function get_pesel() : String;

    constructor Create(AOwner: TComponent; tryb: Boolean);
  end;

var
  DlgOsoba: TDlgOsoba;

implementation

uses FormOsoby, DataModule;
{$R *.dfm}

constructor TDlgOsoba.Create(AOwner: TComponent; tryb: Boolean);
var
   poz : Integer;

begin
   inherited Create(AOwner);

   set_tryb(tryb);

   if tryb_update then begin
      set_idosoby(DM.ClientDataSet1.FieldByName('IDOSOBY').AsInteger);
      set_nazwisko(DM.ClientDataSet1.FieldByName('NAZWISKO').AsString);
      set_imie(DM.ClientDataSet1.FieldByName('IMIE').AsString);
      set_dataur(DM.ClientDataSet1.FieldByName('DATAUR').AsdateTime);
      set_mcowosc(DM.ClientDataSet1.FieldByName('MCOWOSC').AsString);
      set_ulicainr(DM.ClientDataSet1.FieldByName('ULICAINR').AsString);
      set_kodp(DM.ClientDataSet1.FieldByName('KODP').AsString);
      set_miasto(DM.ClientDataSet1.FieldByName('MIASTO').AsString);
      set_pesel(DM.ClientDataSet1.FieldByName('PESEL').AsString);
   end
   else begin
      set_idosoby(-1);
      set_nazwisko('');
      set_imie('');
      set_dataur(Now());
      set_mcowosc('');
      set_ulicainr('');
      set_kodp('');
      set_miasto('');
      set_pesel('');
   end;
end;

procedure TDlgOsoba.set_tryb(tryb : Boolean);
begin
   tryb_update := tryb;
end;

procedure TDlgOsoba.set_idosoby(Value: Integer);
begin
   idosoby := Value;
end;

procedure TDlgOsoba.set_nazwisko(Value: String);
begin
   nazwisko        := Value;
   meNazwisko.Text := nazwisko;
end;

procedure TDlgOsoba.set_imie(Value: String);
begin
   imie        := Value;
   meImie.Text := imie;
end;

procedure TDlgOsoba.set_dataur(Value: TDateTime);
begin
   dataur         := Value;
   dtpdataur.Date := dataur;
end;

procedure TDlgOsoba.set_mcowosc(Value: String);
begin
   mcowosc        := Value;
   meMcowosc.Text := mcowosc;
end;

procedure TDlgOsoba.set_ulicainr(Value: String);
begin
   meUlicainr.Text := Value;
end;

procedure TDlgOsoba.set_kodp(Value: String);
begin
   meKodp.Text := Value;
end;

procedure TDlgOsoba.set_miasto(Value: String);
begin
   meMiasto.Text := Value;
end;

procedure TDlgOsoba.set_pesel(Value: String);
begin
   mePesel.Text := Value;
end;

function TDlgOsoba.get_idosoby() : Integer;
begin
   Result := idosoby;
end;

function TDlgOsoba.get_nazwisko() : String;
begin
   Result := meNazwisko.Text;
end;

function TDlgOsoba.get_imie() : String;
begin
   Result := meImie.Text;
end;

function TDlgOsoba.get_dataur() : TDateTime;
begin
   Result := dtpDataUr.Date;
end;

function TDlgOsoba.get_mcowosc() : String;
begin
   Result := meMcowosc.Text;
end;

function TDlgOsoba.get_ulicainr() : String;
begin
   Result := meUlicaInr.Text;
end;

function TDlgOsoba.get_kodp() : String;
begin
   Result := meKodp.Text;
end;

function TDlgOsoba.get_miasto() : String;
begin
   Result := meMiasto.Text;
end;

function TDlgOsoba.get_pesel() : String;
begin
   Result := mePesel.Text;
end;

procedure TDlgOsoba.BitBtn1Click(Sender: TObject);
var
   TD : TTransactionDesc;

begin
   if meNazwisko.Text = '' then begin
      meNazwisko.Color := clRed;
      meNazwisko.SetFocus();
      EXIT;
   end;
         
   idosoby  := get_idosoby();
   nazwisko := get_nazwisko();
   imie     := get_imie();
   dataur   := get_dataur();
   mcowosc  := get_mcowosc();
   ulicainr := get_ulicainr();
   kodp     := get_kodp();
   miasto   := get_miasto();
   pesel    := get_pesel();

   with DM do begin
      if tryb_update then begin
         SQLDataSetEdit.ParamByName('IDOSOBY').AsInteger := idosoby;
         SQLDataSetEdit.ParamByName('NAZWISKO').AsString := nazwisko;
         SQLDataSetEdit.ParamByName('IMIE').AsString     := imie;
         SQLDataSetEdit.ParamByName('DATAUR').AsString   := dateToStr(dataur);
         SQLDataSetEdit.ParamByName('MCOWOSC').AsString  := mcowosc;
         SQLDataSetEdit.ParamByName('ULICAINR').AsString := ulicainr;
         SQLDataSetEdit.ParamByName('KODP').AsString     := kodp;
         SQLDataSetEdit.ParamByName('MIASTO').AsString   := miasto;
         SQLDataSetEdit.ParamByName('PESEL').AsString    := pesel;

         // wykoananie polecenia SQL INSERT
         try
            try
               if not SQLConnection1.InTransaction then begin
                  SQLDataSet1.Close();
                                 
                  TD.TransactionID  := 1;
                  TD.IsolationLevel := xilREADCOMMITTED;

                  SQLConnection1.StartTransaction(TD);
                  SQLDataSetEdit.ExecSQL();
                  SQLConnection1.Commit(TD);
                  ModalResult := mrOK;
               end
               else begin
                  ShowMessage('InTransaction');
               end;
            except
               SQLConnection1.Rollback(TD);
               ShowMessage('Rollback');            
            end;
         finally
            SQLDataSetEdit.Close();
         end;
      end
      else begin
         SQLDataSet1.Close();

         SQLDataSetInsert.ParamByName('NAZWISKO').AsString := nazwisko;
         SQLDataSetInsert.ParamByName('IMIE').AsString     := imie;
         SQLDataSetInsert.ParamByName('DATAUR').AsString   := DateToStr(dataur);
         SQLDataSetInsert.ParamByName('MCOWOSC').AsString  := mcowosc;
         SQLDataSetInsert.ParamByName('ULICAINR').AsString := ulicainr;
         SQLDataSetInsert.ParamByName('KODP').AsString     := kodp;
         SQLDataSetInsert.ParamByName('MIASTO').AsString   := miasto;
         SQLDataSetInsert.ParamByName('PESEL').AsString    := pesel;

         // wykoananie polecenia SQL INSERT
         try
            try
               if not SQLConnection1.InTransaction then begin
                  TD.TransactionID  := 1;
                  TD.IsolationLevel := xilREADCOMMITTED;

                  SQLConnection1.StartTransaction(TD);
                  SQLDataSetInsert.ExecSQL();
                  SQLConnection1.Commit(TD);
                  ModalResult := mrOK;
               end
               else begin
                  ShowMessage('InTransaction');
               end;
            except
               SQLConnection1.Rollback(TD);
               ShowMessage('Rollback');
            end;
         finally
            SQLDataSetInsert.Close();
         end;
      end;
   end;
end;

procedure TDlgOsoba.dtpDataUrChange(Sender: TObject);
begin
   if DateToStr(dtpDataUr.Date) = '' then begin
      dtpdataUr.Color := clRed;
      dtpDataur.SetFocus();
      EXIT;
   end
   else begin
      dtpdataUr.Color := clWindow;
   end;
end;

procedure TDlgOsoba.dtpDataUrExit(Sender: TObject);
begin
   if DateToStr(dtpDataUr.Date) = '' then begin
      dtpdataUr.Color := clRed;
      dtpDataur.SetFocus();
      EXIT;
   end
   else begin
      dtpdataUr.Color := clWindow;
   end;
end;

procedure TDlgOsoba.meNazwiskoExit(Sender: TObject);
begin
   if meNazwisko.Text = '' then begin
      meNazwisko.Color := clRed;
      meNazwisko.SetFocus();
   end
   else begin
      meNazwisko.Color := clWindow;
   end;
end;

end.

