unit MWTrackBar;

interface

uses
   SysUtils, Classes, Controls, ComCtrls, DBCtrls, DB;

type
MTrackBar = class(TTrackBar)
private
   FDataLink : TFieldDataLink;

   function    GetDataField: string;
   procedure   SetDataField (Value: string);
   function    GetDataSource: TDataSource;
   procedure   SetDataSource (Value: TDataSource);
   function    GetField: TField;

protected
   procedure   DataChange (Sender: TObject);

public
   constructor Create (AOwner: TComponent); override;
   destructor  Destroy; override;
   property    Field: TField read GetField;

published
   property DataField : string      read GetDataField  write SetDataField;
   property DataSource: TDataSource read GetDataSource write SetDataSource;
end;

procedure Register;

implementation

constructor MTrackBar.Create(AOwner: TComponent);
begin
   inherited Create (AOwner);

   FDataLink              := TFieldDataLink.Create;
   FDataLink.Control      := self;
   FDataLink.OnDataChange := DataChange;
end;

destructor MTrackBar.Destroy();
begin
   FDataLink.Free;
   FDataLink := nil;

   inherited Destroy;
end;

function MTrackBar.GetDataField() : string;
begin
   Result := FDataLink.FieldName;
end;

procedure MTrackBar.SetDataField(Value: string);
begin
   FDataLink.FieldName := Value;
end;

function MTrackBar.GetDataSource() : TDataSource;
begin
   Result := FDataLink.DataSource;
end;

procedure MTrackBar.SetDataSource(Value: TDataSource);
begin
   FDataLink.DataSource := Value;
end;

function MTrackBar.GetField: TField;
begin
   Result := FDataLink.Field;
end;

procedure MTrackBar.DataChange(Sender: TObject);
begin
   if (FDataLink.Field <> nil) and (FDataLink.Field is TNumericField) then begin
      Position := FDataLink.Field.AsInteger
   end
   else begin
      Position := Min;
   end;
end;

procedure Register;
begin
   RegisterComponents('ABC', [MTrackBar]); 
end;

end.
