unit TryComboBox;

interface

uses
  SysUtils, Classes, Controls, StdCtrls;

type
TMiesiace = 1..12;

TMWComboBox = class(TComboBox)
private
   fMc       : TMiesiace;
   fOnChange : TNotifyEvent;

protected
   procedure Zmiana; dynamic;

public
   procedure SetMc(const Value: TMiesiace);
   function  GetMc: TMiesiace;
   procedure Wypelnij_i_ustaw_mc();

   constructor Create(AOwner: TComponent; pParent : TWinControl);

published
   property OnChange : TNotifyEvent read fOnChange write FOnChange;
   property Mc       : TMiesiace    read GetMc     write SetMc;
end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('USER', [TMWComboBox]);
end;

constructor TMWComboBox.Create(AOwner: TComponent; pParent : TWinControl);
begin
   inherited Create(AOwner);

   Parent := pParent;
   Width  := 40;

   Wypelnij_i_ustaw_mc();
end;

procedure TMWComboBox.Zmiana();
begin
   if Assigned(fOnChange) then begin
      FOnChange(Self);
   end;
end;

procedure TMWComboBox.SetMc(const Value: TMiesiace);
var
   poz : integer;
   ss  : String;

begin
   fMc := Value;
   ss  := IntToStr(Value);

   poz := Items.IndexOf(ss);
   if poz > -1 then begin
      ItemIndex := poz;
   end
   else begin
      ItemIndex := -1;
   end;

   Zmiana();
end;

function TMWComboBox.GetMc(): TMiesiace;
begin
   Result := fMc;
end;

procedure TMWComboBox.Wypelnij_i_ustaw_mc();
var
   mc      : integer;
   Year, Month, Day, Hour, Min, Sec, MSec: Word;
   dzisiaj : TDateTime;
   poz     : Integer;
   seekmc  : Integer;
   ss      : String;

begin
   if not (csDesigning in ComponentState ) then begin
      for mc := 1 to 12 do begin
         Items.Add(IntToStr(mc));
      end;
   end;

   dzisiaj := Now();
   DecodeDate(dzisiaj, Year, Month, Day);
   seekmc := month;
   ss     := IntToStr(seekmc);

   poz := Items.IndexOf(ss);

   if poz > -1 then begin
      ItemIndex     := poz;
      fMc := Month;
   end;
end;

end.
