unit FormOsoby;

interface

uses
  Windows, Messages, Classes, SysUtils, Graphics, Controls, StdCtrls, Forms,
  Dialogs, DBCtrls, DB, DBGrids, Grids, ExtCtrls, ActnList, Buttons, Variants;

type
  TFOsoby = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton2: TSpeedButton;
    ActionFiltruj: TAction;
    ActionFindKey: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ActionFiltrujExecute(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure ActionFindKeyExecute(Sender: TObject);
  private
    { private declarations }
    filtr : String;    
  public
    { public declarations }
    procedure  my_filter();
    procedure  my_find();
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.DFM}

uses
   DataModule;

procedure TFOsoby.FormCreate(Sender: TObject);
begin
   Left  := 0;
   Width := Screen.Width;
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if key = VK_F7 then begin
      my_filter();
   end;

   if key = VK_F8 then begin
      my_find();
   end;
end;

procedure TFOsoby.ActionFiltrujExecute(Sender: TObject);
begin
   my_filter();
end;

procedure TFOsoby.SpeedButton7Click(Sender: TObject);
begin
   my_find();
end;

procedure TFOsoby.my_filter();
var
   nazwisko : String;
   
begin
   nazwisko := '';
   nazwisko := InputBox('Wybr osb', 'Podaj nazwisko', '');

   if nazwisko <> '' then begin
      if DM.TableOsoby.Filtered then begin
         DM.TableOsoby.Filtered := False;
      end;

      DM.set_filtr(nazwisko);
      DM.TableOsoby.Filtered := True;

   end
   else begin
      DM.TableOsoby.Filtered := False;
   end;
end;

procedure TFOsoby.ActionFindKeyExecute(Sender: TObject);
begin
   my_find();
end;

procedure TFOsoby.my_find();
var
   nazwisko : String;
   imie     : String;

begin
   nazwisko := InputBox('Wybr osoby', 'Podaj nazwisko', '');

   if nazwisko <> '' then begin
      imie := InputBox('Wybr osoby', 'Podaj imi', '');

      if imie <> '' then begin
         if not DM.TableOsoby.FindKey([nazwisko, imie]) then begin
            ShowMessage('Osoba: ' + nazwisko + ' ' + imie + #10#13 +
                        'nie znaleziona');
         end;
      end;
   end;
end;

end.

