unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBClient, MConnect, ComCtrls, ExtCtrls, Buttons, Grids,
  DBGrids, StdCtrls;

type
  TForm1 = class(TForm)
    DCOMConnection: TDCOMConnection;
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ClientDataSet: TClientDataSet;
    DBGrid1: TDBGrid;
    SpeedButton1: TSpeedButton;
    DataSource: TDataSource;
    Timer: TTimer;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonUtrwalZmianyClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ClientDataSetAfterPost(DataSet: TDataSet);
    procedure ClientDataSetAfterDelete(DataSet: TDataSet);
    procedure ClientDataSetAfterInsert(DataSet: TDataSet);
    procedure ClientDataSetReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
Uses
   RecError;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   Close();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   DCOMConnection.Connected := True;
   ClientDataSet.Active     := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   DCOMConnection.Connected := False;
   ClientDataSet.Active     := False;
end;

procedure TForm1.ButtonUtrwalZmianyClick(Sender: TObject);
begin
   ClientDataSet.ApplyUpdates(-1);
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
   if ClientDataSet.ChangeCount = 0 then begin
      ClientDataSet.Refresh();
   end;
end;

procedure TForm1.ClientDataSetAfterPost(DataSet: TDataSet);
begin
   if ClientDataSet.ChangeCount > 0 then begin
      ClientDataSet.ApplyUpdates(-1);
   end;
end;

procedure TForm1.ClientDataSetAfterDelete(DataSet: TDataSet);
begin
   if ClientDataSet.ChangeCount > 0 then begin
      ClientDataSet.ApplyUpdates(-1);
   end;
end;

procedure TForm1.ClientDataSetAfterInsert(DataSet: TDataSet);
begin
   if ClientDataSet.ChangeCount > 0 then begin
      ClientDataSet.ApplyUpdates(-1);
   end;
end;

procedure TForm1.ClientDataSetReconcileError(DataSet: TCustomClientDataSet;
                                             E: EReconcileError; UpdateKind: TUpdateKind;
                                             var Action: TReconcileAction);
begin
   Action := HandleReconcileError(DataSet, UpdateKind, E);
end;

end.

