unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBClient, MConnect, ComCtrls, ExtCtrls, Buttons, Grids,
  DBGrids, StdCtrls;

type
  TForm1 = class(TForm)
    DCOMConnection: TDCOMConnection;
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ClientDataSet: TClientDataSet;
    DBGrid1: TDBGrid;
    SpeedButton1: TSpeedButton;
    DataSource: TDataSource;
    ButtonUtrwalZmiany: TBitBtn;
    sbPokazDelte: TSpeedButton;
    Timer: TTimer;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonUtrwalZmianyClick(Sender: TObject);
    procedure sbPokazDelteClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ClientDataSetAfterPost(DataSet: TDataSet);
    procedure ClientDataSetAfterDelete(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
   FormDelta,
   TypInfo;


{$R *.dfm}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   Close();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   DCOMConnection.Connected := True;
   ClientDataSet.Active     := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   DCOMConnection.Connected := False;
   ClientDataSet.Active     := False;
end;

procedure TForm1.ButtonUtrwalZmianyClick(Sender: TObject);
begin
   ClientDataSet.ApplyUpdates(-1);
end;

procedure TForm1.sbPokazDelteClick(Sender: TObject);
var
   Res : TModalResult;
begin
   if ClientDataSet.ChangeCount > 0 then begin
      FDelta := TFDelta.Create(Self);

      try
         FDelta.ClientDataSetForDelta.Data := ClientDataSet.Delta;
         FDelta.ClientDataSetForDelta.Open();

         res := FDelta.ShowModal();
      finally
         FreeAndNil(FDelta);
      end;
   end;
end;

procedure TForm1.TimerTimer(Sender: TObject);
begin
   if ClientDataSet.ChangeCount = 0 then begin
      ClientDataSet.Refresh();
   end;
end;

procedure TForm1.ClientDataSetAfterPost(DataSet: TDataSet);
begin
   if ClientDataSet.ChangeCount > 0 then begin
      ClientDataSet.ApplyUpdates(-1);
   end;
end;

procedure TForm1.ClientDataSetAfterDelete(DataSet: TDataSet);
begin
   if ClientDataSet.ChangeCount > 0 then begin
      ClientDataSet.ApplyUpdates(-1);
   end;
end;

end.

