/*	KSIAZKI		*/
use biblioteka;

drop table ksiazki;

CREATE TABLE KSIAZKI
(
IDKSIAZKI	int unsigned not null auto_increment primary key,
IDAUTORA	int unsigned not null,
IDAUTORA2	int unsigned,
IDWYDAL		int unsigned NOT NULL,
ROKWYDANIA	int unsigned,
TYTUL		char(50) NOT NULL,
TYTUL2		char(50) default null,
CENA            decimal(4,2)
);

ALTER TABLE ksiazki add constraint KSIAZKI_FK_IDWYDAL FOREIGN KEY(idwydal) references WYDAWNICTWA(idwydal)
ON DELETE NO ACTION;

ALTER TABLE ksiazki add constraint KSIAZKI_FK_IDAUTORA FOREIGN KEY(idautora) references AUTORZY(idautora)
ON DELETE NO ACTION;

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
1, 1, 2002, 'Delphi Almanach');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
2, 2, 2000, 'Programowanie w Delphi 5');

insert into KSIAZKI(idautora, idautora2, idwydal, rokwydania, tytul, tytul2) values(
3, 3, 1, 2002, 'Projektowanie zorientowane obiektowo', 'Wzorce projektowe');

insert into KSIAZKI(idautora, idautora2, idwydal, rokwydania, tytul, tytul2) values(
4, 5, 1, 2002, 'Delphi 6', 'Vademecum profesjonalisty');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul, tytul2) values(
5, 1, 2002, 'Delphi 6', 'Praktyka programowania');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul, tytul2) values(
6, 1, 1999, 'Delphi 4', 'Tworezenie systemw bazodanowych');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
7, 1, 1996, 'SQL');

insert into KSIAZKI(idautora, idwydal, rokwydania, tytul) values(
8, 1, 2001, 'SQL w InterBase dla Windows i Linuksa');


select idksiazki, tytul, format(cena,2 ) from KSIAZKI;

show columns from ksiazki;
