﻿using System;
using System.Text;
using System.Runtime.InteropServices;
namespace Advanced.NET.Debugging.Chapter5
{
    class NativeEvent
    {
        private IntPtr nativeHandle;
        public IntPtr NativeHandle { get { return nativeHandle; } }
        public NativeEvent(string name)
        {
            nativeHandle = CreateEvent(IntPtr.Zero,
            false,
            true,
            name);
        }
        ~NativeEvent()
        {
            if (nativeHandle != IntPtr.Zero)
            {
                CloseHandle(nativeHandle);
                nativeHandle = IntPtr.Zero;
            }
        }
        [DllImport("kernel32.dll")]
        static extern IntPtr CreateEvent(IntPtr lpEventAttributes,
        bool bManualReset,
        bool bInitialState,
        string lpName);
        [DllImport("kernel32.dll")]
        static extern IntPtr CloseHandle(IntPtr lpEvent);
    }
    class Finalize
    {
        static void Main(string[] args)
        {
            Finalize f = new Finalize();
            f.Run();
        }
        public void Run()
        {
            NativeEvent nEvent = new NativeEvent("MyNewEvent");
            //
            // Użycie nEvent
            //
            nEvent = null;
            Console.WriteLine("Naciśnij dowolny klawisz, aby uruchomić GC");
            Console.ReadKey();
            GC.Collect();
            Console.WriteLine("Naciśnij dowolny klawisz, aby uruchomić GC");
            Console.ReadKey();
            GC.Collect();
            Console.WriteLine("Naciśnij dowolny klawisz, aby zakończyć");
            Console.ReadKey();
        }
    }
}
