# `tidyr` w praktyce: eksplorowanie statystyk z obszaru edukacji

W tej sekcji użyjemy rzeczywistego zbioru danych, aby pokazać, że zmiana kształtu danych za pomocą pakietu `tidyr` jest integralną częścią procesu eksploracji danych. [Dane](data/) w tym przykładzie zostały pobrane z [eskploratora danych Banku Światowego](https://data.worldbank.org/), gdzie dostępne są setki różnych wskaźników ekonomicznych i społecznych. W tym przykładzie uwzględniono [wskaźniki edukacyjne](http://datatopics.worldbank.org/education/) reprezentujące poziom edukacji (lub inwestycji w szkolnictwo) w poszczególnych krajach - np. wydatki rządowe na edukację, wskaźniki piśmienności, wskaźniki skolaryzacji i dziesiątki innych pomiarów.

W ramach eksplorowania tych danych w różnych ujęciach [kod](analysis.R) generuje następujące wykresy pozwalające na porównania między państwami i obserwowanie zmian w czasie:

## Porównywanie wydatków na edukację w latach 1990 i 2014 (według państw)

![Wykres punktowy wydatków na edukację w latach 1990 i 2014](imgs/expenditure_chart-pl.png)

## Ocena zmian nakładów na edukację w określonym miejscu (w Hiszpanii) 

![Wykres liniowy zmian nakładów na edukację w Hiszpanii](imgs/spain_chart-pl.png)

## Porównanie poziomu piśmienności i wskaźnika bezrobocia wśród kobiet (według państw)

![Wykres punktowy poziomu piśmienności i wskaźnika bezrobocia wśród kobiet](imgs/lit_chart-pl.png)