# dplyr w praktyce: analizowanie danych na temat lotw

# Wczytywanie pakietu nycflights13 w celu uzyskania dostpu do ramki danych flights.
install.packages("nycflights13") # Raz w kadym komputerze.
library("nycflights13")          # W kadym skrypcie.
library("dplyr")                 # Wczytywanie biblioteki dplyr.
library("ggplot2")               # Na potrzeby tworzenia wykresw.

# Zapoznawanie si ze zbiorem danych flights.
?flights          # Wywietlanie dostpnej dokumentacji.
dim(flights)      # Sprawdzanie liczby wierszy i kolumn.
colnames(flights) # Sprawdzanie nazw kolumn.
View(flights)     # Wywietlanie ramki danych w przegldarce w rodowisku RStudio.

# Znajdowanie linii lotniczych (carrier) z najwiksz liczb
# opnionych lotw.
has_most_delays <- flights %>%            # Zaczynamy od ramki danych fligths.
  group_by(carrier) %>%                   # Grupowanie wedug linii lotniczych (carrier).
  filter(dep_delay > 0) %>%               # Wyszukiwanie samych opnie.
  summarize(num_delay = n()) %>%          # Zliczanie obserwacji.
  filter(num_delay == max(num_delay)) %>% # Znajdowanie grupy z najwiksz liczb obserwacji.
  select(carrier)                         # Pobieranie nazwy linii lotniczych.

# Pobieranie nazwy linii lotniczych z najwiksz liczb opnie.
most_delayed_name <- has_most_delays %>%  # Rozpoczynanie od uzyskanej wczeniej odpowiedzi.
  left_join(airlines, by = "carrier") %>% # Zczanie na podstawie identyfikatora linii.
  select(name)                            # Pobieranie nazwy linii lotniczych.

print(most_delayed_name$name) # Dostp do wartoci z ramki tibble.

# Obliczanie redniego opnienia przylotw (arr_delay) 
# dla kadego docelowego lotniska (dest).
most_early <- flights %>%
  group_by(dest) %>%                 # Grupowanie na podstawie docelowego lotniska.
  summarize(delay = mean(arr_delay)) # Obliczanie redniego opnienia.

# Obliczanie redniego opnienia dla docelowych lotnisk z pominiciem wynikw NA.
most_early <- flights %>%
  group_by(dest) %>%                               # Grupowanie wedug docelowych lotnisk.
  summarize(delay = mean(arr_delay, na.rm = TRUE)) # Obliczanie redniego opnienia.

# Identyfikowanie lokalizacji, gdzie loty rednio docieraj najwczeniej wzgldem planu.
most_early <- flights %>%
  group_by(dest) %>% # Grupowanie wedug lokalizacji docelowej.
  summarize(delay = mean(arr_delay, na.rm = TRUE)) %>% # Obliczanie redniego opnienia.
  filter(delay == min(delay, na.rm = TRUE)) %>% # Filtrowanie pod ktem najmniejszego opnienia.
  select(dest, delay) %>% # Pobieranie lokalizacji docelowej (i opnienia w celu zapisania go).
  left_join(airports, by = c("dest" = "faa")) %>% # Zczanie z ramk danych airports.
  select(dest, name, delay) # Pobieranie szukanych zmiennych wyjciowych.

print(most_early)

# Identyfikowanie miesica, w ktrym loty maj zwykle najwiksze opnienia.
flights %>%
  group_by(month) %>% # Grupowanie na podstawie odpowiedniego atrybutu.
  summarize(delay = mean(arr_delay, na.rm = TRUE)) %>% # Podsumowanie na podstawie opnie.
  filter(delay == max(delay)) %>% # Filtrowanie pod ktem szukanego rekordu.
  select(month) %>% # Pobieranie kolumny z odpowiedzi na pytanie.
  print() # Bezporednie wywietlanie ramki tibble.

# Obliczanie opnie wedug miesicy i dodawanie nazw miesicy na potrzeby wizualnej prezentacji wynikw.
# Zauwa, e month.name to zmienna wbudowana w jzyku R.
delay_by_month <- flights %>%
  group_by(month) %>%
  summarize(delay = mean(arr_delay, na.rm = TRUE)) %>%
  select(delay) %>%
  mutate(month = month.name)

# Tworzenie wykresu za pomoc pakietu ggplot2 (opisanego w rozdziale 17.).
ggplot(data = delay_by_month) +
  geom_point(
    mapping = aes(x = delay, y = month), 
    color = "blue",
    alpha = .4, 
    size = 3
  ) +
  geom_vline(xintercept = 0, size = .25) +
  xlim(c(-20, 20)) +
  scale_y_discrete(limits = rev(month.name)) +
  labs(title = "rednie opnienie w poszczeglnych miesicach", 
       y = "", x = "Opnienie (w minutach)")

  