<cfparam name="FORM.tourName" default="1">

<!--- Queries the database for the tour name, adult price, and child price; data is filtered so that the only record retrieved corresponds to what the user entered into the form. --->
<cfquery name="rs_tourprices_filtered" datasource="newland">
SELECT tourID, tourName, basePriceAdult, basePriceChild
FROM tbl_tours
WHERE tourID = #FORM.tourName#
</cfquery>

<!--- Form validation script; redirects user back to tourprice.asp if form fields do not have numeric values --->
<cfif Not IsNumeric(form.numAdults) or Not IsNumeric(form.numChildren)>
	<cflocation url="tourprice.cfm?error=notnumeric">
</cfif>

<!--- Collects data for number of adults and children, and the prices for both adults and children; multiplies data to calculate total. --->
<cfset numAdult = form.numAdults>
<cfset numChild = form.numChildren>
<cfset basePriceAdult = #rs_tourprices_filtered.basePriceAdult#>
<cfset basePriceChild = #rs_tourprices_filtered.basePriceChild#>
<cfset tourPrice = (numAdult * basePriceAdult) + (numChild * basePriceChild)>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Newland Tours: Tour Price Calculator</title>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1250" />
<link href="css/newland.css" rel="stylesheet" type="text/css" />
</head>

<body>
<a href="#top"><img src="images/spacer.gif" alt="Skip to main page content" width="1" height="1" border="0" align="left" /></a>
<table width="750" border="0" cellpadding="3" cellspacing="0">
 <tr>
  <td><img src="images/banner_left.gif" width="451" height="68" alt="Newland Tours Banner, Left." /></td>
  <td width="280"><img src="images/banner_right.jpg" width="276" height="68" alt="Newland Tour Banner, Right." /></td>
 </tr>
 <tr>
  <td><img src="images/navbar.gif" name="navbar" width="450" height="20" border="0" usemap="#navbarMap" alt="Navigation Bar." /></td>
  <td><img name="copyright_bar" src="images/copyright_bar.gif" width="272" height="20" border="0" alt="Copyright 2006 Newland Tours." /></td>
 </tr>
 <tr>
  <td colspan="2" background="contact.cfm">	
	<h1><br />
	  <a name="top" id="top"></a>Kalkulator ceny wyjazdu </h1>
    <p>Przybliony koszt wybranego przez Ciebie wyjazdu, <strong><cfoutput>#rs_tourprices_filtered.tourName#</cfoutput></strong>,wynosi <strong><cfoutput>#DollarFormat(tourPrice)#</cfoutput></strong>.</p>
    <p>Podana cena obejmuje nocleg, hotel i inne wydatki zwizane z podrami podczas wyjazdu. Nie zawiera natomiast opat lotniskowych.</p>
    <p><a href="tourprice.cfm">Oblicz cen innego</a> innego wyjazdu.</p>
    <p><a href="contact.cfm">Skontaktuj si</a> z jednym z naszych wykwalifikowanych agentw. </p></td>
 </tr>
</table>

<br />


<map name="navbarMap" id="navbarMap">
 <area shape="rect" coords="1,0,62,20" href="index.cfm" alt="Home" />
 <area shape="rect" coords="71,0,117,20" href="about.cfm" alt="About" />
 <area shape="rect" coords="129,0,196,20" href="tours.cfm" alt="Find Tours" />
 <area shape="rect" coords="209,0,311,20" href="profiles.cfm" alt="Country Profiles" />
 <area shape="rect" coords="327,0,434,20" href="contact.cfm" alt="Contact An Agent" />
</map>
</body>
</html>