DROP DATABASE IF EXISTS newland_tours;
CREATE DATABASE newland_tours;
USE newland_tours;

SET FOREIGN_KEY_CHECKS=1;
-- ----------------------------
-- Table structure for tbl_agents
-- ----------------------------
DROP TABLE IF EXISTS `tbl_agents`;
CREATE TABLE `tbl_agents` (
  `agentID` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL default '0',
  `specialty` int(11) NOT NULL default '0',
  PRIMARY KEY  (`agentID`),
  KEY `agentID` (`agentID`),
  KEY `tbl_regiontbl_agents` (`specialty`),
  KEY `tbl_userstbl_agents` (`user`),
  KEY `userID` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Table structure for tbl_country
-- ----------------------------
DROP TABLE IF EXISTS `tbl_country`;
CREATE TABLE `tbl_country` (
  `countryID` int(11) NOT NULL AUTO_INCREMENT,
  `region` int(11) default '0',
  `countryName` varchar(50) default NULL,
  `population` int(11) default '0',
  `country_currency` varchar(50) default NULL,
  `description` text,
  `imageURL` varchar(50) default NULL,
  `imageALT` varchar(255) default NULL,
  PRIMARY KEY  (`countryID`),
  KEY `countryID` (`countryID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Table structure for tbl_journal
-- ----------------------------
DROP TABLE IF EXISTS `tbl_journal`;
CREATE TABLE `tbl_journal` (
  `journalID` int(11) NOT NULL AUTO_INCREMENT,
  `author` varchar(50) NOT NULL,
  `journal_entry` text,
  PRIMARY KEY  (`journalID`),
  KEY `journalID` (`journalID`),
  KEY `userID` (`author`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Table structure for tbl_region
-- ----------------------------
DROP TABLE IF EXISTS `tbl_region`;
CREATE TABLE `tbl_region` (
  `regionID` int(11) NOT NULL AUTO_INCREMENT,
  `regionName` varchar(50) default NULL,
  PRIMARY KEY  (`regionID`),
  KEY `regionID` (`regionID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Table structure for tbl_tours
-- ----------------------------
DROP TABLE IF EXISTS `tbl_tours`;
CREATE TABLE `tbl_tours` (
  `tourID` int(11) NOT NULL AUTO_INCREMENT,
  `tourName` varchar(50) default NULL,
  `country` int(11) NOT NULL default '0',
  `tour_description` varchar(255) default NULL,
  `itinerary` text,
  `numNights` int(11) NOT NULL default '0',
  `exerciseReqd` tinyint(1) default NULL,
  `tour_imageURL` varchar(50) default NULL,
  `tour_imageALT` varchar(255) default NULL,
  `basePriceAdult` double default '0',
  `basePriceChild` double default '0',
  `meals_per_day` int(11) default '0',
  PRIMARY KEY  (`tourID`),
  KEY `numDays` (`numNights`),
  KEY `tbl_countrytbl_tours` (`country`),
  KEY `tourID` (`tourID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Table structure for tbl_users
-- ----------------------------
DROP TABLE IF EXISTS `tbl_users`;
CREATE TABLE `tbl_users` (
  `userID` int(11) NOT NULL AUTO_INCREMENT,
  `firstName` varchar(50) default NULL,
  `lastName` varchar(50) default NULL,
  `username` varchar(50) default NULL,
  `pwd` varchar(50) default NULL,
  `userGroup` varchar(50) default NULL,
  `address1` varchar(50) default NULL,
  `address2` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `state_province` varchar(50) default NULL,
  `zip_postal` varchar(50) default NULL,
  `country` varchar(50) default NULL,
  PRIMARY KEY  (`userID`),
  KEY `userID` (`userID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `tbl_agents` VALUES ('1', '3', '1');
INSERT INTO `tbl_agents` VALUES ('2', '2', '4');
INSERT INTO `tbl_agents` VALUES ('3', '1', '3');
INSERT INTO `tbl_country` VALUES ('1', '1', 'Kanada', '30007094', 'dolar kanadyjski', 'Kraj pooony na pnoc od USA, znany ze swej dwujzycznoci (jzyki: francuski i angielski), hokeja, wodospadu Niagara, i Parku Narodowego Banff.', 'images/vancouver.jpg', 'Vancouver o zmierzchu');
INSERT INTO `tbl_country` VALUES ('2', '3', 'Wochy', '57634300', 'euro', 'agodny, rdziemnomorski klimat, gry, plae i bogata historia sprawiaj, e Wochy s ulubionym celem podry. Najbardziej znane miasta to m.in.: Rzym, Neapol, Florencja, Wenecja, Piza i Mediolan. Charakterystyczne obiekty religijne to Watykan, Katedra Il Duomo oraz Kaplica Sykstyska.', 'images/colosseum.jpg', 'Rzymskie Koloseum (fragment)');
INSERT INTO `tbl_country` VALUES ('3', '4', 'Tajwan', '22370461', 'nowy dolar tajwaski', 'Oficjalna nazwa Tajwanu (dawniej Formoza) to Republika Chiska. Kraj ten stanowi przykad wietnie rozwijajacej si demokracji na wschd od Chin kontynentalnych. Taiwan synie zarwno z gr i wwozw, jak i muzew sztuki.', 'images/chiang_kaishek.jpg', 'Sala koncertowa przy mauzoleum Czang Kai-szeka w Tajpej');
INSERT INTO `tbl_country` VALUES ('4', '4', 'Japonia', '125931533', 'jen', 'Kraj pooony na wyspach wschodniej Azji. Japonia jest krajem bogatej i zrnicowanej kultury oraz piknych gr. Blisko 80 procent kraju pokryte jest grami, z ktrych wiele podlega ochronie w ramach systemu parkw narodowych.', 'images/miyajima.jpg', 'Wyspa Miyajima w Japonii');
INSERT INTO `tbl_country` VALUES ('5', '3', 'Francja', '58804944', 'euro', 'Od paryskich ulicznych kawiarenek po alpejskie domki grskie i kasyna Lazurowego Wybrzea, Francja jest staym celem wycieczek. Zwiedzaj gry, opalaj si na rdziemnomorskiej play lub podziwiaj Pary ze szczytu wiey Eiffla.', 'images/paris.jpg', 'Pary o wicie');
INSERT INTO `tbl_country` VALUES ('6', '3', 'Wielka Brytania', '58970119', 'funt szterling', 'Wielka Brytania, skadajca si z Anglii, Walii, Szkocji oraz Irlandii Pnocnej, jest popularnym miejscem podry. Znajdziesz tu zarwno zgiek nowoczesnego Londynu, jak i redniowieczny urok miasteczek i wiosek rozsianych bujnie po kraju. Wielka Brytania posiada wiele zabytkw historycznych, ktre warto zobaczy.', 'images/stonehenge.jpg', 'Tajemniczy Stonehenge');
INSERT INTO `tbl_country` VALUES ('7', '2', 'Peru', '26111110', 'sol', 'Kraj pooony w wikszoci w grzystych Andach, na zachodnim wybrzeu Ameryki Poudniowej. Peru byo pierwotnie ojczyzn wielkiej staroytnej cywilizacji Inkw. Do dzi mona w Peru spotka wiele ruin inkaskich, cznie z Machu Picchu.', 'images/machu_picchu.jpg', 'Peru: inkaskie ruiny w Machu Picchu');
INSERT INTO `tbl_country` VALUES ('8', '8', 'Meksyk', '98552776', 'peso', 'Meksyk, poudniowy ssiad USA, ley midzy Oceanem Spokojnym na zachodzie a Zatok Meksykask i Morzem Karaibskim po stronie wschodniej. Oprcz zrnicowanego krajobrazu i bogatej historii Meksyk posiada te wiele nowoczesnych miast i kurortw, co czyni z tego kraju wyjtkowo ekscytujcy cel podry.', 'images/mexican_ruins.jpg', 'Ruiny Majw na pwyspie Jukatan');
INSERT INTO `tbl_country` VALUES ('9', '6', 'Namibia', '1622328', 'dolar namibijski', 'Namibia (dawniej Afryka Poudniowo-Zachodnia) rozciga si od Oceanu Atlantyckiego po kotlin Kalahari. Jednym z jej najwikszych powodw do sawy jest jedyny w swoim rodzaju Park Narodowy Etosha, gdzie yj pantery, antylopy, yrafy, sonie, flamingi i nosoroce.', 'images/etosha.jpg', 'Park Narodowy Etosha w Namibii');
INSERT INTO `tbl_country` VALUES ('10', '5', 'Izrael', '5643966', 'nowy szekel izraelski', 'Kraj, na obszarze ktrego znajduj si najwitsze miejsca trzech najwikszych religii: chrzecijastwa, islamu i judaizmu. Izrael to surowy kraj, idealny do wdrwek i odkrywania.', 'images/wailing_wall2.jpg', 'ciana Paczu w Jerozolimie');
INSERT INTO `tbl_country` VALUES ('11', '6', 'Egipt', '66050004', 'funt egipski', 'Egipt jest ojczyzn jednej z najbardziej zaawansowanych - i dobrze zachowanych - cywilizacji staroytnoci. Synie z piramid, grobowcw, Nilu i wielu innych charakterystycznych obiektw. 90 procent powierzchni kraju pokrywa niezamieszkaa pustynia.', 'images/sphinx.jpg', 'Sfinks z piramid w tle. Giza (Egipt)');
INSERT INTO `tbl_country` VALUES ('12', '1', 'USA', '270311758', 'dolar amerykaski', 'Stany Zjednoczone, pooone w Ameryce Pnocnej midzy Kanad a Meksykiem, to ogromny kraj o zrnicowanej topografii i kulturze. Stany Zjednoczone, zasiedlone pocztkowo przez Europejczykw, stay si prawdziwym tyglem ras i kultur, zyskujc jedyn w swoim rodzaju kultur i styl.', 'images/dc.jpg', 'Waszyngton - widok na Washington Monument');
INSERT INTO `tbl_country` VALUES ('13', '4', 'Tajlandia', '60037366', 'bat', 'Tajlandia, znana dawniej jako Syjam, ley w poudniowo-wschodniej Azji midzy Birm, Kambod, Laosem i Zatok Tajlandzk. Tajlandia posiada niepowtarzaln, star kultur, znajdujc swoje odbicie w sztuce i architekturze.', 'images/mae_hong_son.jpg', 'Tajlandzka witynia w Mae Hong Son');
INSERT INTO `tbl_country` VALUES ('14', '6', 'Maroko', '29114497', 'dirham', 'Maroko, pooone w pnocno-wschodniej czci kontynentu afrykaskiego, charakteryzuje si zrnicowanym spoeczestwem i bogat histori. Posiada rwnie urozmaicone uksztatowanie terenu: oprcz wybrzey Oceanu Atlantyckiego i Morza rdziemnomorskiego wystpuj tu te gry i tereny pustynne.', 'images/mor_sahara.jpg', 'Pustynia Sahara w Maroku');
INSERT INTO `tbl_country` VALUES ('15', '2', 'Argentyna', '36265463', 'peso argentyskie', 'Drugi pod wzgldem powierzchni kraj Ameryki Poudniowej, rozcigajcy si od Andw po kilka wysp na Oceanie Atlantyckim a po Punta Dungeness, najdalej na poudnie wysunity punkt kontynentu. Tysice kilometrw wybrzea oraz jedne z najwspanialszych acuchw grskich na wiecie czyni z Argentyny raj dla turystw.', 'images/fitzroy.jpg', 'Onieone szczyty w Parku Narodowym Fitzroy w Argentynie');
INSERT INTO `tbl_country` VALUES ('16', '7', 'Indie', '984003683', 'rupia', 'Indie, sidmy co do wielkoci kraj wiata, i drugi pod wzgldem liczby ludnoci, to kraj, ktrego nie mona przemierzy w weekend. Ta ogromna masa ldu, rozcigajca si od Himalajw po wybrzee Oceanu Indyjskiego tworzy wasny subkontynent. Staroytna kultura i wielowiekowa historia sprawiaj, e jest to ulubiony kraj dla mionikw poznawania nowych kultur.', 'images/ganges.jpg', 'Indyjskie miasto Varanasi nad rzek Ganges');
INSERT INTO `tbl_journal` VALUES ('1', 'lseldon@mirth.net', '<h3>Wycieczka do Woch bya hitem</h3>\r\n<p class=\"author\">Ryszard Bochenek</p>\r\n<p>Wanie wrciem z wycieczki Atrakcje Woch. Wzilimy w niej udzia wraz z dwiema innymi rodzinami.</p>');
INSERT INTO `tbl_journal` VALUES ('4', 'wendy@peachpit.com', '<h3>Modzie na tropach Majw</h3>\r\n<p class=\"author\">Helena Oleska</p>\r\n<p>Nasze biuro podry organizowao ostatnio wycieczk modziey licealnej do Chichen Itza w Meksyku. Podczas wycieczki uczniowie zobaczyli staroytne ruiny Majw i wytwory ich sztuki oraz poznali informacje na temat \"zagadki Majw\".</p>\r\n<p>Majowie byli jedn z najbardziej zaawansowanych cywilizacji do czasu, gdy w tajemniczy sposb zniknli przed wiekami. Cho archeolodzy nie wiedz dokadnie, co si stao z Majami, dowody wskazuj na wojn jako prawdopodobn przyczyn. Na podstawie dowiadcze z tej wycieczki uczniowie przygotuj grup sprawozda, ktre zostan nastpnie zebrane w cao przez uczestniczce w zadaniu druyny.</p>');
INSERT INTO `tbl_region` VALUES ('1', 'Ameryka Pnocna');
INSERT INTO `tbl_region` VALUES ('2', 'Ameryka Poudniowa');
INSERT INTO `tbl_region` VALUES ('3', 'Europa');
INSERT INTO `tbl_region` VALUES ('4', 'Azja Wchodnia');
INSERT INTO `tbl_region` VALUES ('5', 'Azja Zachodnia');
INSERT INTO `tbl_region` VALUES ('6', 'Afryka');
INSERT INTO `tbl_region` VALUES ('7', 'Azja rodkowa');
INSERT INTO `tbl_region` VALUES ('8', 'Ameryka rodkowa');
INSERT INTO `tbl_tours` VALUES ('2', 'Atrakcje Woch', '2', 'Poznaj arcydziea woskiego renesansu podczas podry po redniowiecznych i renesansowych miastach Woch.', 'Rzym: 3 noclegi<br />Florencja: 2 noclegi<br />Siena: 1 nocleg<br />Piza: 1 nocleg', '7', '0', 'images/firenze.jpg', 'Florencja o zachodzie soca. W tle widoczna katedra Santa Maria del Fiore (Duomo)', '799', '399', '2');
INSERT INTO `tbl_tours` VALUES ('3', 'Wdrwki po Hokkaido', '4', 'Poznaj dziewicze tereny pnocnej Japonii podczas siedmiu caodniowych wypraw prowadzcych wrd legendarnych, onieonych szczytw Hokkaido. Tylko dla powanych piechurw!', 'Sapporo: 3 noclegi<br />Park narodowy Daisetsuzan: 4 noclegi', '7', '1', 'images/hokkaido.jpg', 'Pokryte niegiem gry Hokkaido, Japonia', '699', '499', '3');
INSERT INTO `tbl_tours` VALUES ('4', 'Atrakcje Japonii', '4', 'Poznaj rnorodno Japonii - od spokoju wity po zgiek miejskiego ycia. Zobacz najwyszy szczyt Japonii - gr Fuji (3776 m n.p.m.), zwiedzaj witynie, spaceruj po ogrodach i odwied sklepy w najelegantszych dzielnicach handlowych Japonii.', 'Tokio: 2 noclegi<br />Nagoja: 1 nocleg<br />Kioto: 2 noclegi<br />Wyspa Miyajima: 2 noclegi', '7', '0', 'images/temple.jpg', 'witynia Heian Jingu w prefekturze Kyoto', '1199', '899', '2');
INSERT INTO `tbl_tours` VALUES ('5', 'Atrakcje Francji', '5', 'Zobacz co Francja ma najlepszego do zaoferowania w tej penej zabawy wycieczce, idealnej dla caej rodziny. Spd trzy dni w Paryu, cznie z wycieczk po Wersalu, odwied poudnie Francji i zwied Marsyli, a na zakoczenie sawny kurort w Nicei.', 'Pary: 3 noclegi<br />Marsylia: 2 noclegi<br />Nicea: 2 noclegi', '7', '0', 'images/eiffel.jpg', 'Wiea Eiffla, Pary, Francja', '999', '499', '2');
INSERT INTO `tbl_tours` VALUES ('6', 'Na podbj Lazurowego Wybrzea', '5', 'Wdruj od nieba do raju podczas szeciodniowej pieszej podry z Cannes do Nicei.', 'Cannes: 1 nocleg<br />[Midzy Cannes a Nice]: 4 noclegi<br />Nicea: 1 nocleg', '6', '1', 'images/riviera.jpg', 'Nadmorskie kurorty Lazurowego Wybrzea', '799', '299', '3');
INSERT INTO `tbl_tours` VALUES ('7', 'Atrakcje Wielkiej Brytanii', '6', 'Od Big Bena po Edinburgh Castle; poznaj histori Zjednoczonego Krlestwa od redniowiecza po wspczesno. Idealna wycieczka dla caej rodziny.', 'Londyn: 3 noclegi<br />Oksford: 1 nocleg<br />Edynburg: 2 noclegi', '6', '0', 'images/bigben.jpg', 'Londyska wiea zegarowa Big Ben', '999', '699', '2');
INSERT INTO `tbl_tours` VALUES ('8', 'Rowerem z Oksfordu do Londynu', '6', 'Tydzie wzdu brzegw Tamizy na tygodniowej wycieczce rowerowej z Oksfordu do Londynu przez Reading.', 'Oksford (i okolice): 2 noclegi<br />Reading (and environs): 3 noclegi<br />Londyn (i okolice): 1 nocleg', '6', '1', 'images/oxford.jpg', 'Ulice Oksfordu noc', '699', '399', '3');
INSERT INTO `tbl_tours` VALUES ('9', 'Machu Picchu', '7', 'Na dugo przed przybyciem Europejczykw do Ameryki rodkowej i Poudniowej panoway tu trzy rdzenne cywilizacje: Aztekowie, Majowie oraz Inkowie. Ruiny Machu Picchu, pozostao po Inkach, s jednym z najbardziej imponujcych miejsc na wiecie.', 'Lima: 2 noclegi<br />Machu Picchu: 5 noclegw', '7', '0', 'images/machu_picchu.jpg', 'Ruiny Inkw w Machu Picchu, Peru', '799', '499', '3');
INSERT INTO `tbl_tours` VALUES ('10', 'Atrakcje Argentyny', '15', 'Od miejskich wiate Buenos Aires do Mar del Plata - to wycieczka, ktra zapewni doskonay wypoczynek. Zakupy w modnych sklepach, wyjtkowa kuchnia i wylegiwanie si na plaach w najlepszych miejscowociach wypoczynkowych Ameryki Poudniowej.', 'Buenos Aires: 3 noclegi<br />Mar del Plata: 3 noclegi', '6', '0', 'images/arg_waterfall.jpg', 'Wodospad Iguzu, Argentyna', '799', '399', '2');
INSERT INTO `tbl_tours` VALUES ('11', 'Ucieczka na Jukatan', '8', 'Ta siedmiodniowa wycieczka przeniesie Ci do dwch wiatw. wiat wspczesny to nowoczesne Cancun, pene pla, barw i zabawy. Nastpnie cofniesz si w czasie podczas wdrwki wrd staroytnych ruin cywilizacji Majw w Chichen Itza.', 'Cancun: 7 noclegw', '7', '0', 'images/mayan_pyramid.jpg', 'Piramida Majw, Pwysep Jukatan, Meksyk', '899', '599', '2');
INSERT INTO `tbl_tours` VALUES ('12', 'Atrakcje pnocnych Indii', '16', 'Zobacz grzyste Indie pnocne z najlepszej strony. Po dwch dniach odpoczynku w miejscowoci wypoczynkowej Dehra Dun, odwiedzimy ttnic yciem stolic Indii, New Delhi. Nastpnie udamy si do Agry, gdzie znajduje si synna Tad Mahal.', 'Dehra Dun: 2 noclegi<br />New Delhi: 3 noclegi<br />Agra: 2 noclegi', '7', '0', 'images/taj_mahal.jpg', 'Tad Mahal, Agra, Indie', '1099', '799', '2');
INSERT INTO `tbl_tours` VALUES ('13', 'Park Narodowy Etosha', '9', 'Poznaj jeden z najwikszych parkw narodowych Afryki. Zobacz dzikie afrykaskie zwierzta: sonie, pantery i antylopy. Wycieczka wymaga pieszych wdrwek.', 'Windhoek: 1 nocleg<br />Park Narodowy Etosha: 5 noclegw', '6', '1', 'images/etosha.jpg', 'Park Narodowy Etosha, Namibia', '799', '599', '3');
INSERT INTO `tbl_tours` VALUES ('14', 'Atrakcje Tajlandii', '13', 'Zwied cztery odrbne miasta podczas podry kolej wzdu rzeki Menam z Bangkoku do Phitsanulok, miasta otoczonego murami z XIII wieku, gdzie znajduje si synny posg Buddy.', 'Bangkok: 2 noclegi<br />Pathum Thani: 1 nocleg<br />Nakhon Sawan: 1 nocleg<br />Phitsanulok: 2 noclegi', '6', '0', 'images/thai_wat.jpg', 'witynia Wat, Tajlandia', '799', '499', '3');
INSERT INTO `tbl_tours` VALUES ('15', 'Egipskie piramidy i nie tylko', '11', 'Spd sze dni poznajc Kair (stolic Egiptu) i jego okolice, w tym piramidy, Sfinksa i wiele innych znanych miejsc staroytnoci.', 'Kair: 6 dni', '6', '0', 'images/ramses.jpg', 'Posg Ramzesa, Egipt', '999', '699', '2');
INSERT INTO `tbl_tours` VALUES ('16', 'Atrakcje Izraela', '10', 'Zobacz wiele najwitszych miejsc chrzecijastwa, islamu i judaizmu w czasie siedmiodniowej podry po Izraelu. Odwiedzisz m.in. cian Paczu oraz miejsca narodzin Dawida i Jezusa.', 'Jerozolima: 7 noclegw<br />Jerycho [caodzienna wycieczka]<br />Betlejem [caodzienna wycieczka]', '7', '0', 'images/wailing_wall.jpg', 'ciana Paczu i okolice, Jerozolima', '899', '699', '2');
INSERT INTO `tbl_tours` VALUES ('17', 'Atrakcje Maroka', '14', 'Maroko czy w sobie tradycje berberyjskie, arabskie, europejskie i afrykaskie. Zobaczysz Casablank, lotnisko aliantw z czasw II wojny wiatowej, a nastpnie udasz si do stolicy kraju i dalej, gdzie zwiedzisz ruiny upadego imperium.', 'Casablanca: 1 nocleg<br />Rabat: 2 noclegi<br />Sale: 1 nocleg<br />Tetouan: 2 noclegi', '6', '0', 'images/ait_benhaddou.jpg', 'Forteca Ait Benhaddou, Maroko', '799', '499', '3');
INSERT INTO `tbl_tours` VALUES ('18', 'Atrakcje wschodniego wybrzea USA', '12', 'Podczas tej wycieczki zobaczysz najbardziej znane miejsca USA, od pomnika Waszyngtona po Statu Wolnoci. Po drodze odwiedzisz Biay Dom, Dzwon Wolnoci, Wall Street oraz port w Bostonie.', 'Waszyngton: 2 noclegi<br />Filedelfia: 2 noclegi<br />Nowy Jork: 2 noclegi<br />Boston: 2 noclegi', '8', '0', 'images/liberty.jpg', 'Statua Wolnoci, Nowy Jork, USA', '1199', '899', '2');
INSERT INTO `tbl_tours` VALUES ('19', 'Kalifornia na rolkach!', '12', 'Ruszaj na rolki przez soneczn Kaliforni. Przejed si po Fisherman\'s Wharf w San Francisco i Mission Bay w San Diego. Oprcz tego odwiedzisz skate park, gdzie bdziesz mg powiczy skoki i lizgi pod okiem wykwalifikowanego instruktora.', 'San Francisco: 2 noclegi<br />Monterey: 1 nocleg<br />San Diego: 4 noclegi', '7', '1', 'images/golden_gate.jpg', 'Most Golden Gate noc, San Francisco, USA', '899', '699', '2');
INSERT INTO `tbl_tours` VALUES ('20', 'Atrakcje zachodniej Kanady', '1', 'Poznaj Kanad, jakiej nie znae: od nocnego ycia w kosmopolitycznym Vancouver po gorce rda Banff wysoko w kanadyjskich Grach Skalistych. W programie piesze wycieczki wok Parku Stanley\'a i po grskich szlakach w Banff.', 'Vancouver: 2 noclegi<br />Banff: 4 noclegi', '6', '1', 'images/banff.jpg', 'Miasteczko Banff w kanadyjskich Grach Skalistych', '799', '499', '2');
INSERT INTO `tbl_users` VALUES ('1', 'Ellen', 'Olenska', 'eolenska@sixdegrees.net', 'freespirit', 'go', '512 5th Avenue', '', 'New York', 'NY', '10010', 'USA');
INSERT INTO `tbl_users` VALUES ('2', 'Lawrence', 'Seldon', 'lseldon@mirth.net', 'flirtatious', 'go', '258 Fashion Blvd.', '', 'New York', 'NY', '10011', 'USA');
INSERT INTO `tbl_users` VALUES ('3', 'Zuzanna', 'Fromm', 'zfromm@starknet.pl', 'hipochondryk', 'administrator', 'Sankowa 10', '', 'Pustkowie', 'mazowieckie', '01-123', 'Polska');
INSERT INTO `tbl_users` VALUES ('4', 'Paul,Pasolini,Pasolini', 'Pasolini', 'ppasol@poesia.it', 'pastoral', 'go', '22 Via Priziano', '', 'Milano', '', '', 'Italy');
INSERT INTO `tbl_users` VALUES ('7', 'Osiris', 'Bardzell', 'osiris@allectomedia.com', 'osiris', 'go', '245 Science Diet Blvd.', '', 'Bloomington', 'IN', '47401', 'USA');
